/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation;

import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ServiceException;

/**
 * An exception thrown by {@link IndexedRelations} to indicate problems in index
 * operation execution. The real problem can be found in the cause of this
 * exception.
 * 
 * @author Tuukka Lehtonen
 */
public class IndexException extends RuntimeDatabaseException {

    private static final long serialVersionUID = -947989446491250462L;

    public IndexException(ServiceException cause) {
        super(cause);
    }

    public IndexException(String message, Throwable cause) {
        super(message, cause);
    }

    public IndexException(String message) {
        super(message);
    }

    public IndexException(Throwable cause) {
        super(cause);
    }

}
