/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - further development
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation;

import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TypeString;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

class Entry implements Comparable<Entry> {

	Entry(Resource parent, Resource resource, String name, String types, String id) {
		this.parent = parent;
		this.resource = resource;
		this.name = name;
		this.types = types;
		this.id = id;
	}

	Entry(ReadGraph graph, Layer0 L0, Resource resource) throws DatabaseException {
		this.parent = graph.getPossibleObject(resource, L0.PartOf);
		this.resource = resource;
		this.name = graph.getPossibleRelatedValue(resource, L0.HasName, Bindings.STRING);
		Set<Resource> typeSet = graph.getTypes(resource);
		this.types = graph.syncRequest(new TypeString(L0, typeSet));
		this.id = IndexQueries.idFromGUID(graph.getPossibleRelatedValue(resource, L0.identifier, GUID.BINDING));
		this.typeId = IndexQueries.toResourceIdString(typeSet);
	}

	Entry(ReadGraph graph, Resource resource) throws DatabaseException {
		this(graph, Layer0.getInstance(graph), resource);
	}

	final Resource parent;
	final Resource resource;

	String types;
	String name;
	String id;
	String typeId;
	Resource principalType;
	byte[] guid;

	@Override
	public int compareTo(Entry o) {
		int names = name.compareTo(o.name);
		if(names != 0) return names;
		int resources = resource.compareTo(o.resource);
		if(resources != 0) return resources;
		return id.compareTo(o.id);
	}

	@Override
	public int hashCode() {
		return resource.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		Entry other = (Entry)obj;
		return resource.equals(other.resource);
	}

}