/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import java.util.Collection;
import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.TGConfigurer;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2.SeedSpec;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2.SeedSpec.SeedSpecType;

public class SharedOntologyCopyHandler extends DefaultCopyHandler {

    public SharedOntologyCopyHandler(Resource resource) {
    	super(resource);
    }

    public SharedOntologyCopyHandler(Collection<Resource> resources) {
    	super(resources);
    }
    
    @Override
    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {

    	if(resources.size() != 1) throw new DatabaseException("Assumed a single root");

    	Resource root = resources.iterator().next();
    	String uri = graph.getURI(root);
    	Collection<SeedSpec> roots = Collections.singletonList(new SeedSpec(root, uri, SeedSpecType.ROOT));
    	return new TGConfigurer(graph, true, false).roots(roots).create();
    	
    }

}
