/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;

public class FixedRootImportAdvisor implements IImportAdvisor {

	protected Resource root;
	
	public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
	}
	
	@Override
	public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
		return null;
	}

	@Override
	public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
		Layer0 b = graph.getService(Layer0.class);
		this.root = graph.newResource();
		String name = root.name;
		graph.addLiteral(this.root, b.HasName, b.NameOf, b.String, name, Bindings.STRING);
		return this.root;
	}
	
	public Resource getRoot() {
		return root;
	}
	
}
