/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.StringModifierFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;

/**
 * Makes sure that two things apply for L0.HasName of any entity:
 * <ol>
 * <li>An entity must not have the same name as any of its
 * L0.PartOf/L0.ConsistsOf related siblings</li>
 * <li>An entity's name must not begin with one or more dots ('.'). Due to
 * limitations imposed by the Variable specification no resources in the
 * simantics database should be named beginning with one or more dots. '.' is
 * variable browsing syntax for "parent" (see
 * {@link Variable#browse(ReadGraph, String)}). This is comparable to file
 * systems and the use of '.' and '..' therein.</li>
 * </ol>
 * 
 * @author Tuukka Lehtonen
 */
public final class EntityStringModifierFactory implements StringModifierFactory {

    private Resource subject;

    public EntityStringModifierFactory(Resource subject) throws DatabaseException {
        this.subject = subject;
    }

    @Override
    public StringModifier createModifier(ReadGraph graph, Resource relation, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);

        // Names require special care in validation.
        if (L0.HasName.equals(relation)) {
            return new EntityNameModifier(graph, subject, property);
        }

        return null;
    }

}
