/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.util.RemoverUtil;

/**
 * This is a preliminary interface for making resource removal adapter-driven.
 * Adapt a resource to {@link Remover} to specify a custom logic for removing a
 * certain resource or a certain type of resource. A Remover is not reusable to
 * prevent it from being reused invalidly for unexpected inputs.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see AbstractRemover
 * @see RemoverUtil
 */
public interface Remover {

    /**
     * @param graph
     * @param aux auxiliary data storage that may be used when invoking
     *        {@link #canRemove(ReadGraph, Map)} recursively
     * @return <code>null</code> indicates removal ok, otherwise the result
     *         describes the problems.
     * @throws DatabaseException
     * @since 1.6
     */
    String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException;

    /**
     * @param graph
     * @throws DatabaseException
     */
    void remove(WriteGraph graph) throws DatabaseException;

}
