/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Pair;

public interface GenericRelation {

	/**
	 * Tests whether a tuple belongs to the relation.
	 */
	boolean contains(ReadGraph graph, Object[] tuple) throws DatabaseException;
	
	/**
	 * Tells if realize-method is implemented.
	 */
	boolean isRealizable();
	/**
	 * Returns the contents of the relation as a list.
	 */
	List<Object[]> realize(ReadGraph graph) throws DatabaseException;	
	
	/**
	 * Selects and projects the relation by given binding pattern and constants.
	 * The binding pattern is a string of 'b' and 'f' characters. The length
	 * of constants array has to be the number of 'b' letters in binding pattern.
	 */
	public GenericRelation select(String bindingPattern, Object[] constants);
	
	/**
	 * Restricts the relation by given constraint.
	 */
	public GenericRelation selectByRelation(String bindingPattern, GenericRelation constraint);
	
	/**
	 * Tells the names and types of the fields of the relation.
	 */
	Pair<String, String>[] getFields();
	
	//<T> T getInterface(Class<T> clazz);
	
}
