package org.simantics.db.common.procedure.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;

public class DirectStatementProcedure implements AsyncProcedure<DirectStatements> {

	DirectStatements result = null;
	DatabaseException exception = null;

	@Override
	public void execute(AsyncReadGraph graph, final DirectStatements ds) {
		result = ds;
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable throwable) {
		if(throwable instanceof DatabaseException) {
			exception = (DatabaseException)throwable;
		} else {
			exception = new DatabaseException(throwable);
		}
	}
	
	public DirectStatements getOrThrow() throws DatabaseException {
		if(exception != null) throw exception;
		return result;
	}

}