/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.TIntIntHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusteringSupportImpl;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.query.AssertedPredicates;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.ChildMap;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.Predicates;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryCaches;
import org.simantics.db.impl.query.QueryListening;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.ReadEntry;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.URIToResource;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.QueryDeserializer;
import org.simantics.db.request.QueryFactory;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.Read;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusteringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDeserializerImpl
implements QueryDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDeserializerImpl.class);
    QueryListening listening;
    ResourceSupport resourceSupport;
    ClusteringSupportImpl clusteringSupport;
    QueryCaches qc;
    QuerySupport qs;
    ClusterSupport cs;
    CacheEntry entry;
    private byte[] bytes;
    private int byteIndex;
    private boolean immutable;
    private long cacheId;
    private TIntIntHashMap clusterKeys = new TIntIntHashMap();
    private Map<Integer, QueryFactory> ids = new HashMap<Integer, QueryFactory>();
    private static int reads0 = 0;
    private static int reads1 = 0;

    public QueryDeserializerImpl(QueryProcessor qp, byte[] bytes) {
        this.listening = qp.listening;
        this.resourceSupport = qp.resourceSupport;
        this.clusteringSupport = (ClusteringSupportImpl)qp.getSession().getService(ClusteringSupport.class);
        this.qc = qp.caches;
        this.qs = qp.querySupport;
        this.cs = this.qs.getClusterSupport();
        this.bytes = bytes;
    }

    public byte readByte() {
        return this.bytes[this.byteIndex++];
    }

    public boolean peekZero() {
        return this.bytes[this.byteIndex] == 0 && this.bytes[this.byteIndex + 1] == 0;
    }

    public int readLE2() {
        int result = Bytes.readLE2((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 2;
        return result;
    }

    public int readLE4() {
        int result = Bytes.readLE4((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 4;
        return result;
    }

    public long readLE8() {
        long result = Bytes.readLE8((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 8;
        return result;
    }

    public byte[] readBytes(int len) {
        byte[] result = Arrays.copyOfRange(this.bytes, this.byteIndex, this.byteIndex + len);
        this.byteIndex += len;
        return result;
    }

    public int registerImmutability(long clusterId, boolean immutable) {
        try {
            int clusterKey = this.cs.getClusterTable().getClusterKeyByUID(0L, clusterId);
            this.cs.getClusterTable().markImmutable(clusterKey, immutable);
            return clusterKey;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean readHeaders(boolean skipImmutable) {
        this.cacheId = this.readLE8();
        long clusterId = this.cacheId >> 1;
        boolean bl = this.immutable = this.readByte() == 1;
        if (clusterId > 0L) {
            this.registerImmutability(clusterId, this.immutable);
        }
        if (this.immutable && skipImmutable) {
            return true;
        }
        int idsSize = this.readLE4();
        int i = 0;
        while (i < idsSize) {
            int size = this.readLE4();
            QueryFactoryKey id = QueryFactoryKey.read((String)new String(this.readBytes(size)));
            int key = this.readLE4();
            try {
                Bundle bundle = Platform.getBundle((String)id.getBundle());
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = bundleWiring.getClassLoader();
                Class<?> clazz = classLoader.loadClass(id.classId() + "Factory");
                QueryFactory qf = (QueryFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.ids.put(key, qf);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error("Error while resolving QueryFactory", (Throwable)e);
            }
            ++i;
        }
        int clusterKeysSize = this.readLE4();
        int i2 = 0;
        while (i2 < clusterKeysSize) {
            long referencedClusterId = this.readLE8();
            int key = this.readLE4();
            boolean immu = this.readByte() == 1;
            int actualClusterKey = this.registerImmutability(referencedClusterId, immu);
            this.clusterKeys.put(key, actualClusterKey);
            ++i2;
        }
        return this.immutable;
    }

    public QueryFactory readFactory() {
        int key = this.readLE4();
        return this.ids.get(key);
    }

    public int readQueries() {
        int count = this.readLE4();
        int i = 0;
        while (i < count) {
            QueryFactory qf = this.readFactory();
            try {
                qf.read((QueryDeserializer)this);
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while deserializing query", (Throwable)e);
            }
            catch (Throwable t) {
                LOGGER.error("Failure to deserialize queries", t);
                throw new IllegalStateException("Failure to deserialize queries");
            }
            ++i;
        }
        if (this.immutable) {
            if ((this.cacheId & 1L) == 1L) {
                ++reads1;
            } else {
                ++reads0;
            }
        }
        return count;
    }

    public Resource readResource() throws DatabaseException {
        int id = this.readResourceI();
        if (id == 0) {
            return null;
        }
        return new ResourceImpl(this.resourceSupport, id);
    }

    public Statement readStatement() throws DatabaseException {
        int s = this.readResourceI();
        int p = this.readResourceI();
        int o = this.readResourceI();
        return this.qs.getStatement(s, p, o);
    }

    public int readResourceI() throws DatabaseException {
        if (this.peekZero()) {
            return this.readLE2();
        }
        int key = this.readLE4();
        if (key <= 0) {
            return key;
        }
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKey(key);
        int actualClusterKey = this.clusterKeys.get(clusterKey);
        return ClusterTraitsBase.createResourceKey(actualClusterKey, ClusterTraitsBase.getResourceIndexFromResourceKey(key));
    }

    public byte[] readByteArray() {
        int len = this.readLE4();
        if (len == -1) {
            return null;
        }
        return this.readBytes(len);
    }

    public String readString() {
        return new String(this.readByteArray());
    }

    public ObjectResourceIdMap<String> createChildMap() {
        return this.qs.createChildMap();
    }

    AssertedPredicates readAssertedPredicates() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateAssertedPredicates(r);
    }

    AssertedStatements readAssertedStatements() throws DatabaseException {
        int r1 = this.readResourceI();
        int r2 = this.readResourceI();
        return this.qc.get(r1).getOrCreateAssertedStatements(r1, r2);
    }

    ChildMap readChildMap() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateChildMap(r);
    }

    DirectObjects readDirectObjects() throws DatabaseException {
        int r1 = this.readResourceI();
        int r2 = this.readResourceI();
        return this.qc.get(r1).getOrCreateDirectObjects(r1, r2);
    }

    DirectPredicates readDirectPredicates() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateDirectPredicates(r);
    }

    Objects readObjects() throws DatabaseException {
        int r1 = this.readResourceI();
        int r2 = this.readResourceI();
        return this.qc.get(r1).getOrCreateObjects(r1, r2);
    }

    OrderedSet readOrderedSet() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateOrderedSet(r);
    }

    Predicates readPredicates() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreatePredicates(r);
    }

    PrincipalTypes readPrincipalTypes() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreatePrincipalTypes(r);
    }

    RelationInfoQuery readRelationInfoQuery() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateRelationInfoQuery(r);
    }

    Statements readStatements() throws DatabaseException {
        int r1 = this.readResourceI();
        int r2 = this.readResourceI();
        return this.qc.get(r1).getOrCreateStatements(r1, r2);
    }

    SuperRelations readSuperRelations() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateSuperRelations(r);
    }

    SuperTypes readSuperTypes() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateSuperTypes(r);
    }

    TypeHierarchy readTypeHierarchy() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateTypeHierarchy(r);
    }

    Types readTypes() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateTypes(r);
    }

    URIToResource readURIToResource() throws DatabaseException {
        String s = this.readString();
        return this.qc.get(s).getOrCreateURIToResource(s);
    }

    ValueQuery readValueQuery() throws DatabaseException {
        int r = this.readResourceI();
        return this.qc.get(r).getOrCreateValueQuery(r);
    }

    public void setEntry(CacheEntry entry) {
        this.entry = entry;
    }

    public CacheEntry getEntry() {
        return this.entry;
    }

    public <K, V> void store(K key, V value) {
        if (key instanceof Read) {
            Read r = (Read)key;
            this.setEntry(this.qc.get(r).getOrCreateReadEntry(r));
        } else if (key instanceof CacheEntry) {
            this.setEntry((CacheEntry)key);
        } else {
            throw new IllegalStateException("Illegal key " + String.valueOf(key));
        }
        if (value instanceof Throwable) {
            this.entry.except((Throwable)value);
        } else {
            this.entry.setResult(value);
            this.entry.setReady();
        }
    }

    public <K> void parent(K key) {
        if (this.immutable) {
            return;
        }
        if (key instanceof PersistentRead) {
            PersistentRead r = (PersistentRead)key;
            long cacheId = r.cacheId((ClusteringSupport)this.clusteringSupport);
            long clusterId = cacheId >> 1;
            boolean immutable = this.clusteringSupport.isImmutableClusterId(clusterId);
            if (immutable) {
                return;
            }
            ReadEntry entry = this.qc.get((Read<?>)r).getOrCreateReadEntry((Read<?>)r);
            this.listening.addParent(this.getEntry(), entry);
        } else if (key instanceof CacheEntry) {
            this.listening.addParent(this.getEntry(), (CacheEntry)key);
        } else {
            throw new IllegalStateException("Illegal key " + String.valueOf(key));
        }
    }
}

