/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;

class QueryCollectorImpl2
implements QueryProcessor.QueryCollector {
    private final QueryProcessor queryProcessor;
    private final QueryProcessor.QueryCollectorSupport support;
    private int lastKnownFixedSize = 0;

    QueryCollectorImpl2(QueryProcessor queryProcessor, QueryProcessor.QueryCollectorSupport support) {
        this.queryProcessor = queryProcessor;
        this.support = support;
    }

    private boolean findCollectables(CacheEntry<?> entry, Map<CacheEntry, Boolean> collectables, ArrayList<CacheEntry> result) {
        if (entry.isDiscarded()) {
            return true;
        }
        if (entry.isPending()) {
            collectables.remove(entry);
            return false;
        }
        if (this.queryProcessor.listening.hasListenerAfterDisposing(entry)) {
            collectables.remove(entry);
            return false;
        }
        for (CacheEntry parent : this.queryProcessor.listening.getParents(entry)) {
            boolean parentIsCollectable = false;
            if (!collectables.containsKey(parent)) {
                collectables.put(parent, true);
                parentIsCollectable = this.findCollectables(parent, collectables, result);
            } else {
                parentIsCollectable = collectables.get(parent);
            }
            if (parentIsCollectable) continue;
            collectables.remove(entry);
            return false;
        }
        if (entry.shouldBeCollected()) {
            result.add(entry);
            return true;
        }
        return false;
    }

    private List<CacheEntry> findCollectables() {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        IdentityHashMap<CacheEntry, Boolean> collectables = new IdentityHashMap<CacheEntry, Boolean>();
        Collection<CacheEntry<?>> rootList = this.support.getRootList();
        for (CacheEntry<?> entry : rootList) {
            if (collectables.containsKey(entry)) continue;
            collectables.put(entry, true);
            this.findCollectables(entry, collectables, result);
        }
        return result;
    }

    private void doCollect(int currentSize, int maxNumberOfCollectableQueries) {
        List<CacheEntry> collectables = this.findCollectables();
        int freeCount = collectables.size();
        this.lastKnownFixedSize = currentSize - freeCount;
        if (freeCount < maxNumberOfCollectableQueries) {
            return;
        }
        int target = freeCount - maxNumberOfCollectableQueries / 2;
        for (CacheEntry entry : collectables) {
            if (this.queryProcessor.removeQuery(entry) && --target < 0) break;
        }
        ArrayList<CacheEntry> removals = new ArrayList<CacheEntry>();
        for (CacheEntry cacheEntry : this.support.allCachesForGC().toCollection()) {
            for (CacheEntry cacheEntry2 : this.queryProcessor.listening.getParents(cacheEntry)) {
                if (!cacheEntry2.isDiscarded()) continue;
                removals.add(cacheEntry2);
            }
            for (CacheEntry<Object> cacheEntry3 : removals) {
                this.queryProcessor.listening.removeParent(cacheEntry, cacheEntry3);
            }
            removals.clear();
        }
    }

    @Override
    public void collect(int youngTarget, int maxAllowedTimeInMs) {
        try {
            int current = this.support.calculateCurrentSize();
            this.queryProcessor.caches.collecting = true;
            long start = System.nanoTime();
            this.doCollect(current, 0);
            long l = System.nanoTime() - start;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.queryProcessor.caches.collecting = false;
    }
}

