/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusteringSupportImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QueryDeserializerImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCaches {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryCaches.class);
    private static final int ARRAY_SIZE = 2 * ClusterTraitsBase.getClusterArraySize();
    private final QueryCache[] cacheArray = new QueryCache[ARRAY_SIZE];
    public volatile boolean dirty = false;
    private int currentSize = 0;
    public boolean collecting = false;
    public boolean loading = false;
    AtomicInteger updates = new AtomicInteger(0);
    AtomicInteger size = new AtomicInteger(0);
    final QueryProcessor processor;
    final QuerySupport querySupport;
    final ClusteringSupportImpl clusteringSupport;
    final int threads;
    private final TreeMap<Long, QueryCacheBase> priorityQueue = new TreeMap();

    public QueryCaches(QueryProcessor processor, int threads) {
        this.processor = processor;
        this.querySupport = processor.querySupport;
        this.clusteringSupport = (ClusteringSupportImpl)processor.getSession().getService(ClusteringSupport.class);
        this.threads = threads;
        this.cacheArray[0] = new QueryCache(this, 0);
    }

    public final int r1(long id) {
        return (int)(id >>> 32);
    }

    int cacheKey(int clusterKey, boolean user) {
        return (clusterKey << 1) + (user ? 1 : 0);
    }

    long cacheId(long clusterId, boolean user) {
        return (clusterId << 1) + (long)(user ? 1 : 0);
    }

    boolean isUser(int cacheIdOrKey) {
        return (cacheIdOrKey & 1) == 1;
    }

    synchronized QueryCache get(int r) {
        if (r < 0) {
            return this.cacheArray[0];
        }
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(r);
        return this.getByClusterCacheKey(this.cacheKey(clusterKey, false));
    }

    synchronized QueryCache getByClusterCacheKey(int cacheKey) {
        QueryCache cache = this.cacheArray[cacheKey];
        if (cache == null) {
            this.cacheArray[cacheKey] = cache = new QueryCache(this, cacheKey);
            if (!this.loading) {
                long fileId;
                File f;
                File workspace;
                File dir;
                boolean immutable;
                int clusterKey = cacheKey >> 1;
                boolean bl = immutable = clusterKey == 0 ? false : this.clusteringSupport.isImmutableClusterId(clusterKey);
                if (immutable && (dir = new File(workspace = Platform.getLocation().toFile(), "queryData")).exists() && (f = new File(dir, (fileId = (this.clusteringSupport.clusterIdByClusterKey(clusterKey) << 1) + (long)(this.isUser(cacheKey) ? 1 : 0)) + ".queryData")).exists()) {
                    try {
                        byte[] bytes = FileUtils.readFile((File)f);
                        QueryDeserializerImpl qd = new QueryDeserializerImpl(this.processor, bytes);
                        boolean immutable2 = qd.readHeaders(false);
                        if (immutable2) {
                            qd.readQueries();
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Error while restoring queries");
                    }
                }
            }
        }
        return cache;
    }

    QueryCache get(long id) {
        return this.get(this.r1(id));
    }

    QueryCache get(MultiRead<?> read) {
        return this.cacheArray[0];
    }

    QueryCache get(AsyncMultiRead<?> read) {
        return this.cacheArray[0];
    }

    QueryCache get(ExternalRead<?> read) {
        return this.cacheArray[0];
    }

    QueryCache get(Read<?> read) {
        if (read instanceof PersistentRead) {
            long cacheId = ((PersistentRead)read).cacheId((ClusteringSupport)this.clusteringSupport);
            long clusterId = cacheId >> 1;
            if (clusterId == 0L) {
                return this.cacheArray[0];
            }
            int clusterKey = this.clusteringSupport.clusterKeyByClusterId(clusterId);
            return this.getByClusterCacheKey(this.cacheKey(clusterKey, true));
        }
        return this.cacheArray[0];
    }

    QueryCache get(AsyncRead<?> read) {
        return this.cacheArray[0];
    }

    QueryCache get(String id) {
        return this.cacheArray[0];
    }

    void resetUpdates() {
        this.updates.set(0);
    }

    CacheCollectionResult allCachesForGC(CacheCollectionResult result) {
        int i = 0;
        while (i < ARRAY_SIZE) {
            QueryCache cache = this.cacheArray[i];
            if (cache != null && !cache.isImmutable()) {
                cache.allCaches(result);
            }
            ++i;
        }
        return result;
    }

    public Collection<CacheEntry<?>> getRootList() {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < ARRAY_SIZE) {
            QueryCache cache = this.cacheArray[i];
            if (cache != null) {
                result.addAll(cache.getRootList());
            }
            ++i;
        }
        return result;
    }

    public int calculateCurrentSize() {
        int result = 0;
        int i = 0;
        while (i < ARRAY_SIZE) {
            QueryCache cache = this.cacheArray[i];
            if (cache != null) {
                result += cache.calculateCurrentSize();
            }
            ++i;
        }
        this.currentSize = result;
        return result;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public long getActivity() {
        return this.updates.get();
    }

    ExternalReadEntry getExternal(ExternalRead<?> request) {
        return (ExternalReadEntry)this.cacheArray[0].externalReadEntryMap.get(request);
    }

    Collection<QueryCache> immutableCaches() {
        ArrayList<QueryCache> result = new ArrayList<QueryCache>();
        int i = 0;
        while (i < ARRAY_SIZE) {
            QueryCache cache = this.cacheArray[i];
            if (cache != null && cache.isImmutable()) {
                result.add(cache);
            }
            ++i;
        }
        return result;
    }

    Collection<QueryCache> mutableCaches() {
        ArrayList<QueryCache> result = new ArrayList<QueryCache>();
        int i = 0;
        while (i < ARRAY_SIZE) {
            QueryCache cache = this.cacheArray[i];
            if (cache != null && !cache.isImmutable()) {
                result.add(cache);
            }
            ++i;
        }
        return result;
    }

    public void registerPriorityForSwap(QueryCacheBase cache) {
        if (!cache.isImmutable()) {
            return;
        }
        if (cache.storedPriority > 0L) {
            this.priorityQueue.remove(cache.storedPriority);
        }
        if (cache.currentPriority > 0L) {
            this.priorityQueue.put(cache.currentPriority, cache);
            cache.storedPriority = cache.currentPriority;
        }
    }

    public void dropAll(WriteGraphImpl graph) {
        int i = 1;
        while (i < ARRAY_SIZE) {
            this.cacheArray[i] = null;
            ++i;
        }
        for (CacheEntry<?> entry : this.cacheArray[0].getRootList()) {
            if (entry instanceof ExternalReadEntry) continue;
            this.processor.markForUpdate(graph, entry);
        }
    }

    public QueryCacheBase getSwapCandidate(int targetSize) {
        if (this.priorityQueue.size() > targetSize) {
            return this.priorityQueue.firstEntry().getValue();
        }
        return null;
    }

    public int swapSingle(int targetSize) throws IOException {
        QueryCacheBase base = this.getSwapCandidate(targetSize);
        if (base == null) {
            return -1;
        }
        this.priorityQueue.remove(base.storedPriority);
        this.cacheArray[base.cacheKey] = null;
        return base.persist(this.processor);
    }

    public int swap(int targetSize) throws IOException {
        int count = 0;
        int worked;
        while ((worked = this.swapSingle(targetSize)) != -1) {
            count += worked;
        }
        return count;
    }
}

