/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ClusteringSupportImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializerImpl;
import org.simantics.db.impl.query.StringQuery;

public class URIToResource
extends StringQuery<InternalProcedure<Integer>>
implements InternalProcedure<Integer> {
    URIToResource(String id) {
        super(id);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        QueryCache.remove(provider, this);
    }

    public Object compute(ReadGraphImpl graph, InternalProcedure<Integer> procedure) throws DatabaseException {
        URIToResource.computeForEach(graph, this.id, this, procedure);
        return this.getResult();
    }

    static void computeForEach(ReadGraphImpl graph, final String id, final URIToResource entry, InternalProcedure<Integer> procedure_) throws DatabaseException {
        InternalProcedure<Integer> procedure;
        InternalProcedure<Integer> internalProcedure = procedure = entry != null ? entry : procedure_;
        if ("http://".equals(id) || "http:/".equals(id)) {
            QueryProcessor processor = graph.processor;
            procedure.execute(graph, processor.getRootLibrary());
        } else {
            final String[] parts = URIStringUtils.splitURI((String)id);
            if (parts != null) {
                QueryCache.runnerURIToResource(graph, parts[0], entry, null, new InternalProcedure<Integer>(){

                    @Override
                    public void execute(ReadGraphImpl graph, Integer parentId) throws DatabaseException {
                        ObjectResourceIdMap<String> map = QueryCache.resultChildMap(graph, parentId, entry, null);
                        if (!$assertionsDisabled && map == null) {
                            throw new AssertionError();
                        }
                        int result = map.getId((Object)URIStringUtils.unescape((String)parts[1]));
                        if (result == 0) {
                            ResourceNotFoundException e = new ResourceNotFoundException(id);
                            procedure.exception(graph, (Throwable)e);
                        } else {
                            procedure.execute(graph, result);
                        }
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
                        procedure.exception(graph, throwable);
                    }
                });
            } else {
                ResourceNotFoundException e = new ResourceNotFoundException(id);
                procedure.exception(graph, (Throwable)e);
            }
        }
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrSet(Integer result) {
        assert (this.isPending());
        URIToResource uRIToResource = this;
        synchronized (uRIToResource) {
            this.setResult(result);
            this.setReady();
        }
    }

    public String toString() {
        return "URIToResource[" + this.id + "]";
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, InternalProcedure<Integer> procedure) throws DatabaseException {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return (Throwable)this.getResult();
        }
        Integer result = (Integer)this.getResult();
        procedure.execute(graph, result);
        return result;
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new InternalProcedure<Integer>(){

            @Override
            public void execute(ReadGraphImpl graph, Integer result) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ReadGraphImpl graph, Integer result) throws DatabaseException {
        URIToResource uRIToResource = this;
        synchronized (uRIToResource) {
            this.setResult(result);
            this.setReady();
        }
    }

    @Override
    public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        this.except(throwable);
    }

    @Override
    public long cacheIdImpl(ClusteringSupportImpl support) {
        return 0L;
    }

    @Override
    public void serializeKey(QuerySerializerImpl serializer) {
        serializer.addString(this.id);
    }

    @Override
    public void serializeValue(QuerySerializerImpl serializer) {
        if (this.isExcepted()) {
            serializer.addException();
        } else {
            Integer value = (Integer)this.getResult();
            serializer.addResource(value);
        }
    }

    @Override
    public int type() {
        return 1;
    }
}

