/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UnaryQueryPIntSet;
import org.simantics.db.procedure.ListenerBase;

public final class TypeHierarchy
extends UnaryQueryPIntSet {
    public TypeHierarchy(int resource) {
        super(resource);
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache.runnerTypeHierarchy(graph, r, parent, listener, procedure);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        QueryCache.remove(provider, this);
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<IntSet> procedure) throws DatabaseException {
        TypeHierarchy.computeForEach(graph, this.id, this, procedure);
    }

    public static IntSet computeForEach(ReadGraphImpl graph, int id, TypeHierarchy entry, InternalProcedure<IntSet> procedure_) throws DatabaseException {
        final InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;
        QueryProcessor processor = graph.processor;
        final IntSet result = new IntSet(processor.querySupport, id);
        final TIntProcedure addToResult = new TIntProcedure(){

            public boolean execute(int r) {
                result.add(r);
                return true;
            }
        };
        QueryCache.runnerSuperTypes(graph, id, entry, null, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                types.forEach(addToResult);
                procedure.execute(graph, result);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                procedure.exception(graph, t);
            }
        });
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
        return result;
    }

    public String toString() {
        return "TypeHierarchy[" + this.id + "]";
    }
}

