/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusteringSupportImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializerImpl;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.db.service.ClusteringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadEntry<T>
extends CacheEntryBase<AsyncProcedure<T>>
implements AsyncProcedure<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadEntry.class);
    protected Read<T> id;

    public ReadEntry(Read<T> request) {
        this.id = request;
    }

    @Override
    int makeHash() {
        return this.id.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.id;
    }

    @Override
    public void discard() {
        super.discard();
        this.setResult(null);
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph) {
                try {
                    Object result = ReadEntry.this.id.perform((ReadGraph)graph);
                    ReadEntry.this.setResult(result);
                    ReadEntry.this.setReady();
                }
                catch (Throwable t) {
                    ReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                QueryCache.remove(processor, ReadEntry.this);
            }

            @Override
            public int type() {
                if (ReadEntry.this.id instanceof ReadExt) {
                    return ((ReadExt)ReadEntry.this.id).getType();
                }
                return 0;
            }

            public String toString() {
                if (ReadEntry.this.id == null) {
                    return "DISCARDED";
                }
                return ReadEntry.this.id.toString() + String.valueOf(ReadEntry.this.statusOrException);
            }
        };
    }

    public static <T> T computeForEach(ReadGraphImpl graph, Read<T> request, ReadEntry<T> entry, AsyncProcedure<T> procedure_, boolean needsToBlock) throws DatabaseException {
        ReadEntry<T> procedure = entry != null ? entry : procedure_;
        ReadGraphImpl queryGraph = graph.withParent(entry, null, needsToBlock);
        ReadGraphImpl executeGraph = graph.withParent(graph.parent, null, needsToBlock);
        try {
            Object result = request.perform((ReadGraph)queryGraph);
            if (procedure != null) {
                procedure.execute(executeGraph, result);
            }
            Object object = result;
            return (T)object;
        }
        catch (DatabaseException e) {
            if (procedure != null) {
                procedure.exception(executeGraph, e);
            }
            throw e;
        }
        catch (Throwable t) {
            DatabaseException dbe = new DatabaseException(t);
            if (procedure != null) {
                procedure.exception(executeGraph, dbe);
            }
            throw dbe;
        }
        finally {
            queryGraph.asyncBarrier.dec();
            try {
                if (entry != null) {
                    entry.performFromCache(executeGraph, procedure_);
                }
            }
            finally {
                executeGraph.asyncBarrier.dec();
                if (needsToBlock) {
                    executeGraph.asyncBarrier.waitBarrier(procedure, executeGraph);
                }
            }
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, AsyncProcedure<T> procedure) throws DatabaseException {
        AsyncProcedure<T> proc = procedure;
        if (this.isExcepted()) {
            Throwable t;
            if (proc != null) {
                try {
                    proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
                }
                catch (Throwable t2) {
                    LOGGER.error("performFromCache proc.exception failed", t2);
                }
            }
            if ((t = (Throwable)this.getResult()) instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        if (proc != null) {
            try {
                proc.execute((AsyncReadGraph)graph, this.getResult());
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.execute failed", t);
            }
        }
        return this.getResult();
    }

    public String toString() {
        if (this.id == null) {
            return "DISCARDED";
        }
        return this.id.toString() + " - " + String.valueOf(this.statusOrException);
    }

    public Object get(ReadGraphImpl graph, AsyncProcedure<T> procedure) throws DatabaseException {
        if (procedure != null) {
            this.performFromCache(graph, procedure);
        }
        this.checkAndThrow();
        return this.getResult();
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
        if (this.id instanceof ReadExt) {
            return ((ReadExt)this.id).isImmutable((ReadGraph)graph);
        }
        return false;
    }

    public void execute(AsyncReadGraph graph, T result) {
        this.setResult(result);
        this.setReady();
    }

    public void exception(AsyncReadGraph graph, Throwable throwable) {
        this.except(throwable);
    }

    @Override
    public long cacheIdImpl(ClusteringSupportImpl support) {
        if (this.id instanceof PersistentRead) {
            return ((PersistentRead)this.id).cacheId((ClusteringSupport)support);
        }
        return 0L;
    }

    @Override
    public void serializeKey(QuerySerializerImpl serializer) {
        if (this.id instanceof PersistentRead) {
            ((PersistentRead)this.id).serializeKey((QuerySerializer)serializer);
            return;
        }
        throw new IllegalStateException("Cannot serialize query key for " + String.valueOf(this));
    }

    @Override
    public void serializeValue(QuerySerializerImpl serializer) {
        if (this.id instanceof PersistentRead) {
            ((PersistentRead)this.id).serializeValue((QuerySerializer)serializer, this.getResult());
            return;
        }
        throw new IllegalStateException("Cannot serialize query value for " + String.valueOf(this));
    }

    @Override
    public QueryFactoryKey classId() {
        if (this.id instanceof PersistentRead) {
            return ((PersistentRead)this.id).classId();
        }
        return null;
    }
}

