/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.procedure.TLongLongProcedure;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusteringSupportImpl;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.db.service.ClusteringSupport;

public class QuerySerializerImpl
implements QuerySerializer {
    public QueryProcessor processor;
    private QuerySupport querySupport;
    private ClusteringSupportImpl clusteringSupport;
    private TByteArrayList bytes = new TByteArrayList();
    private TLongLongHashMap clusterInfo = new TLongLongHashMap();
    private Map<String, Integer> ids = new HashMap<String, Integer>();
    private long cacheId;
    private boolean immutable;

    public QuerySerializerImpl(QueryProcessor processor, long cacheId, boolean immutable) {
        this.processor = processor;
        this.querySupport = processor.querySupport;
        this.clusteringSupport = (ClusteringSupportImpl)processor.getSession().getService(ClusteringSupport.class);
        this.cacheId = cacheId;
        this.immutable = immutable;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int writeUnknownSize() {
        int pos = this.bytes.size();
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
        return pos;
    }

    public void setUnknownSize(int pos, int value) {
        this.bytes.set(pos, (byte)(value & 0xFF));
        this.bytes.set(pos + 1, (byte)(value >>> 8 & 0xFF));
        this.bytes.set(pos + 2, (byte)(value >>> 16 & 0xFF));
        this.bytes.set(pos + 3, (byte)(value >>> 24 & 0xFF));
    }

    public void serializeId(QueryFactoryKey qfk) {
        String key = qfk.key();
        Integer id = this.ids.get(key);
        if (id == null) {
            id = this.ids.size() + 1;
            this.ids.put(key, id);
        }
        this.addLE4(id);
    }

    public void addResource(int r) {
        if (r < 0) {
            this.addLE4(r);
        } else if (r == 0) {
            this.addLE2((short)0);
        } else {
            long clusterId = this.querySupport.getClusterId(r);
            long info = this.clusterInfo.get(clusterId);
            if (info == 0L) {
                boolean immu = this.clusteringSupport.isImmutableClusterId(clusterId);
                info = (this.clusterInfo.size() + 1 << 1) + (immu ? 1 : 0);
                this.clusterInfo.put(clusterId, info);
            }
            int clusterKey = (int)(info >> 1);
            int i = ClusterTraitsBase.createResourceKeyNoThrow(clusterKey, ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(r));
            this.addLE4(i);
        }
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            this.addResource(0);
        } else {
            this.addResource(((ResourceImpl)resource).id);
        }
    }

    public void addStatement(Statement stm) {
        this.addResource(stm.getSubject());
        this.addResource(stm.getPredicate());
        this.addResource(stm.getObject());
    }

    public long cluster(Resource resource) {
        return this.processor.cluster(((ResourceImpl)resource).id);
    }

    public void addException() {
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
    }

    public void addString(String s) {
        byte[] b = s.getBytes();
        this.addLE4(b.length);
        this.bytes.add(b);
    }

    public void add(byte b) {
        this.bytes.add(b);
    }

    public void add(byte[] bs) {
        this.bytes.add(bs);
    }

    public byte[] bytes() {
        final TByteArrayList header = new TByteArrayList();
        QuerySerializerImpl.writeLE8(header, this.cacheId);
        header.add(this.immutable ? (byte)1 : 0);
        QuerySerializerImpl.writeLE4(header, this.ids.size());
        for (Map.Entry<String, Integer> entry : this.ids.entrySet()) {
            String id = entry.getKey();
            QuerySerializerImpl.writeLE4(header, id.length());
            header.add(id.getBytes());
            QuerySerializerImpl.writeLE4(header, entry.getValue());
        }
        QuerySerializerImpl.writeLE4(header, this.clusterInfo.size());
        this.clusterInfo.forEachEntry(new TLongLongProcedure(){

            public boolean execute(long clusterId, long info) {
                QuerySerializerImpl.writeLE8(header, clusterId);
                int key = (int)(info >> 1);
                QuerySerializerImpl.writeLE4(header, key);
                byte immu = (byte)(info & 1L);
                header.add(immu);
                return true;
            }
        });
        header.add(this.bytes.toArray());
        return header.toArray();
    }

    public void addLE4(int value) {
        QuerySerializerImpl.writeLE4(this.bytes, value);
    }

    public void addLE2(short value) {
        QuerySerializerImpl.writeLE2(this.bytes, value);
    }

    public static void writeLE4(TByteArrayList bytes, int value) {
        bytes.add((byte)(value & 0xFF));
        bytes.add((byte)(value >>> 8 & 0xFF));
        bytes.add((byte)(value >>> 16 & 0xFF));
        bytes.add((byte)(value >>> 24 & 0xFF));
    }

    public static void writeLE2(TByteArrayList bytes, short value) {
        bytes.add((byte)(value & 0xFF));
        bytes.add((byte)(value >>> 8 & 0xFF));
    }

    public void writeLE8(long value) {
        QuerySerializerImpl.writeLE8(this.bytes, value);
    }

    public static void writeLE8(TByteArrayList bytes, long value) {
        bytes.add((byte)(value & 0xFFL));
        bytes.add((byte)(value >>> 8 & 0xFFL));
        bytes.add((byte)(value >>> 16 & 0xFFL));
        bytes.add((byte)(value >>> 24 & 0xFFL));
        bytes.add((byte)(value >>> 32 & 0xFFL));
        bytes.add((byte)(value >>> 40 & 0xFFL));
        bytes.add((byte)(value >>> 48 & 0xFFL));
        bytes.add((byte)(value >>> 56 & 0xFFL));
    }

    public QueryProcessor getQueryProcessor() {
        return this.processor;
    }

    public void addByte(byte b) {
        this.bytes.add(b);
    }

    public void addBytes(byte[] bs) {
        this.addLE4(bs.length);
        this.bytes.add(bs);
    }
}

