/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializerImpl;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;

public final class Objects
extends CollectionBinaryQuery<IntProcedure>
implements IntProcedure {
    static final InternalProcedure<IntSet> NOP = new InternalProcedure<IntSet>(){

        @Override
        public void execute(ReadGraphImpl graph, IntSet result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    static final TripleIntProcedure NOPT = new TripleIntProcedure(){

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }

        @Override
        public void execute(ReadGraphImpl graph, int s, int p, int o) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }
    };

    public Objects(int r1, int r2) {
        super(r1, r2);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        QueryCache.remove(provider, this);
    }

    private static final IntArray getAssertionMap(ReadGraphImpl graph, int r1, int r2, Objects entry) throws DatabaseException {
        class AssertionMapProc
        implements IntProcedure {
            boolean first = true;
            private IntArray result;
            private final /* synthetic */ int val$r2;
            private final /* synthetic */ Objects val$entry;

            AssertionMapProc(int n, Objects objects) {
                this.val$r2 = n;
                this.val$entry = objects;
            }

            public void addStatement(int s, int p, int o) {
                if (this.result.size() == 0) {
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                } else {
                    int i = 0;
                    while (i < this.result.sizeOrData) {
                        int existingO;
                        int existingP = this.result.data[i + 1];
                        if (p == existingP && (existingO = this.result.data[i + 2]) == o) {
                            return;
                        }
                        i += 3;
                    }
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) throws DatabaseException {
                if (this.result == null) {
                    this.result = QueryCacheBase.resultAssertedStatements(graph, type, this.val$r2, this.val$entry, null);
                } else {
                    int i;
                    IntArray ia;
                    if (this.first) {
                        ia = this.result;
                        this.result = new IntArray();
                        if (ia.data != null) {
                            i = 0;
                            while (i < ia.sizeOrData) {
                                this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                                i += 3;
                            }
                        }
                        this.first = false;
                    }
                    ia = QueryCacheBase.resultAssertedStatements(graph, type, this.val$r2, this.val$entry, null);
                    if (ia.data != null) {
                        i = 0;
                        while (i < ia.sizeOrData) {
                            this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                            i += 3;
                        }
                    }
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable throwable) {
            }
        }
        AssertionMapProc amp = new AssertionMapProc(r2, entry);
        QueryCache.runnerPrincipalTypes(graph, r1, entry, null, amp);
        return amp.result;
    }

    private static final void forSingleAssertion(ReadGraphImpl graph, int r1, int r2, Objects parent, IntProcedure procedure) throws DatabaseException {
        IntArray map = Objects.getAssertionMap(graph, r1, r2, parent);
        if (map == null) {
            procedure.finished(graph);
            return;
        }
        int size = map.size();
        if (size == 3) {
            int value = map.data[2];
            procedure.execute(graph, value);
            procedure.finished(graph);
        } else if (size == 0) {
            procedure.finished(graph);
        } else {
            int candidateS = map.data[0];
            int candidateO = map.data[2];
            IntSet candidateIs = null;
            try {
                candidateIs = QueryCache.resultSuperTypes(graph, candidateS, parent, null);
            }
            catch (DatabaseException e) {
                procedure.exception(graph, e);
                return;
            }
            int i = 3;
            while (i < map.size()) {
                int nextS = map.data[i];
                int nextO = map.data[i + 2];
                if (nextS != candidateS && !candidateIs.contains(nextS)) {
                    IntSet nextIs = null;
                    try {
                        nextIs = QueryCache.resultSuperTypes(graph, nextS, parent, null);
                    }
                    catch (DatabaseException e) {
                        procedure.exception(graph, e);
                        return;
                    }
                    if (nextIs.contains(candidateS)) {
                        candidateS = nextS;
                        candidateO = nextO;
                        candidateIs = nextIs;
                    } else {
                        ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has conflicting assertions " + r1 + ", " + r2 + " " + String.valueOf(map), r1);
                        procedure.exception(graph, (Throwable)exception);
                        return;
                    }
                }
                i += 3;
            }
            procedure.execute(graph, candidateO);
            procedure.finished(graph);
        }
    }

    public final void computeFunctionalIndex(ReadGraphImpl graph, QueryProcessor provider, RelationInfo ri, IntProcedure procedure) throws DatabaseException {
        Objects.computeFunctionalIndex(graph, this.r1(), this.r2(), this, ri, procedure);
    }

    public static final void computeFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Objects parent, RelationInfo ri, final IntProcedure procedure) throws DatabaseException {
        if (ri.isFinal) {
            int result = graph.processor.querySupport.getFunctionalObject(r1, r2);
            if (result == 0) {
                Objects.forSingleAssertion(graph, r1, r2, parent, procedure);
            } else if (result == -1) {
                graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                        procedure.execute(graph, i);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                    }
                });
                Objects.forSingleAssertion(graph, r1, r2, parent, procedure);
            } else {
                procedure.execute(graph, result);
                procedure.finished(graph);
            }
        } else {
            IntSet direct = QueryCache.resultDirectPredicates(graph, r1, null, null);
            direct.forEach(graph, new SyncIntProcedure(){
                int found = 0;

                @Override
                public void run(ReadGraphImpl graph) throws DatabaseException {
                    if (this.found == 1) {
                        procedure.finished(graph);
                    } else if (this.found == 0) {
                        Objects.forSingleAssertion(graph, r1, r2, parent, procedure);
                    }
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred) throws DatabaseException {
                    if (this.found > 0) {
                        return;
                    }
                    if (pred == r2) {
                        QueryCache.runnerDirectObjects(graph, r1, pred, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                if (found == 0) {
                                    procedure.execute(graph, i);
                                    found = 1;
                                } else {
                                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement (r1=" + r1 + ", r2=" + r2 + ").", r1);
                                    procedure.exception(graph, (Throwable)exception);
                                    found = 2;
                                }
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) {
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                procedure.exception(graph, t);
                                found = 2;
                            }
                        });
                    } else {
                        QueryCache.runnerSuperRelations(graph, pred, parent, null, new InternalProcedure<IntSet>(){

                            @Override
                            public void execute(ReadGraphImpl graph, IntSet result) throws DatabaseException {
                                if (found > 0) {
                                    return;
                                }
                                if (result.contains(r2)) {
                                    QueryCache.runnerDirectObjects(graph, r1, pred, null, null, new IntProcedure(){

                                        @Override
                                        public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                            if (found == 0) {
                                                procedure.execute(graph, i);
                                                found = 1;
                                            } else {
                                                ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement (r1=" + r1 + ", r2=" + r2 + ").", r1);
                                                procedure.exception(graph, (Throwable)exception);
                                                found = 2;
                                            }
                                        }

                                        @Override
                                        public void finished(ReadGraphImpl graph) {
                                        }

                                        @Override
                                        public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                            procedure.exception(graph, t);
                                            found = 2;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                procedure.exception(graph, t);
                                found = 2;
                            }
                        });
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) throws DatabaseException {
                    this.dec(graph);
                }
            });
        }
    }

    private static final void forAssertions(ReadGraphImpl graph, int r1, final int r2, final Objects parent, final IntProcedure procedure) throws DatabaseException {
        QueryCache.runnerPrincipalTypes(graph, r1, null, null, new SyncIntProcedure(){
            TripleIntProcedure proc;
            {
                this.proc = new TripleIntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) throws DatabaseException {
                        intProcedure.execute(graph, o);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        intProcedure.exception(graph, t);
                        this.dec(graph);
                    }
                };
            }

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                procedure.finished(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) throws DatabaseException {
                this.inc();
                QueryCache.runnerAssertedStatements(graph, type, r2, parent, null, this.proc);
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        });
    }

    public static final void computeNotFunctionalFinalIndex(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, RelationInfo ri, AsyncMultiProcedure<Resource> procedure) {
        throw new Error();
    }

    public final void computeNotFunctionalIndex(ReadGraphImpl graph, RelationInfo ri, IntProcedure procedure) throws DatabaseException {
        Objects.computeNotFunctionalIndex(graph, this.r1(), this.r2(), this, ri, procedure);
    }

    public static final void computeNotFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Objects parent, RelationInfo ri, final IntProcedure procedure) throws DatabaseException {
        if (ri.isFinal) {
            graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                    procedure.execute(graph, i);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                    procedure.exception(graph, t);
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                }
            });
            if (ri.isAsserted) {
                Objects.forAssertions(graph, r1, r2, parent, procedure);
            } else {
                procedure.finished(graph);
            }
        } else {
            IntSet direct = QueryCache.resultDirectPredicates(graph, r1, null, null);
            direct.forEach(graph, new SyncIntProcedure(){

                @Override
                public void run(ReadGraphImpl graph) throws DatabaseException {
                    Objects.forAssertions(graph, r1, r2, parent, procedure);
                }

                @Override
                public void execute(ReadGraphImpl graph, int pred) throws DatabaseException {
                    if (pred == r2) {
                        QueryCache.runnerDirectObjects(graph, r1, pred, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                procedure.execute(graph, i);
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) throws DatabaseException {
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                procedure.exception(graph, t);
                            }
                        });
                    } else {
                        try {
                            IntSet result = QueryCache.resultSuperRelations(graph, pred, parent, null);
                            if (result.contains(r2)) {
                                this.inc();
                                QueryCache.runnerDirectObjects(graph, r1, pred, null, null, new IntProcedure(){

                                    @Override
                                    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                        procedure.execute(graph, i);
                                    }

                                    @Override
                                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                                        this.dec(graph);
                                    }

                                    @Override
                                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                        procedure.exception(graph, t);
                                        this.dec(graph);
                                    }
                                });
                            }
                        }
                        catch (Throwable e) {
                            procedure.exception(graph, e);
                        }
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) throws DatabaseException {
                    this.dec(graph);
                }
            });
        }
    }

    public Object compute(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        Objects.computeForEach(graph, this.r1(), this.r2(), this, procedure);
        return this.getResult();
    }

    public static void computeForEach(ReadGraphImpl graph, int r1, int r2, Objects entry, IntProcedure procedure_) throws DatabaseException {
        IntProcedure procedure = entry != null ? entry : procedure_;
        RelationInfo ri = QueryCache.resultRelationInfoQuery(graph, r2, entry, null);
        graph.ensureLoaded(r1, r2);
        if (ri.isFunctional) {
            Objects.computeFunctionalIndex(graph, r1, r2, entry, ri, procedure);
        } else {
            Objects.computeNotFunctionalIndex(graph, r1, r2, entry, ri, procedure);
        }
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public String toString() {
        return "Objects[" + this.r1() + " - " + this.r2() + "]";
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return this.getResult();
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
            }
        });
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutableForReading(this.r1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
        IntArray value;
        IntArray intArray = value = (IntArray)this.getResult();
        synchronized (intArray) {
            value.add(i);
        }
    }

    @Override
    public void finished(ReadGraphImpl graph) throws DatabaseException {
        this.setReady();
    }

    @Override
    public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        this.except(throwable);
    }

    @Override
    public void serializeValue(QuerySerializerImpl serializer) {
        IntArray is = (IntArray)this.getResult();
        is.serialize(serializer);
    }
}

