/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UnaryQuery;

public final class DirectSuperRelations
extends UnaryQuery<IntProcedure> {
    public DirectSuperRelations(int resource) {
        super(resource);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        QueryCache.remove(provider, this);
    }

    public Object compute(final ReadGraphImpl graph, final IntProcedure procedure) throws DatabaseException {
        QueryProcessor processor = graph.processor;
        processor.querySupport.ensureLoaded(graph, this.id);
        int single = processor.querySupport.getSingleSuperrelation(this.id);
        if (single > 0) {
            procedure.execute(graph, single);
            procedure.finished(graph);
            return single;
        }
        int subrelationOf = processor.getSubrelationOf();
        IntSet result = new IntSet(processor.querySupport);
        final class DirectProcedure
        extends Ints
        implements IntProcedure,
        TIntProcedure {
            private final /* synthetic */ IntSet val$result;

            DirectProcedure(IntSet intSet) {
                this.val$result = intSet;
            }

            public final boolean execute(int r) {
                this.val$result.add(r);
                return true;
            }

            @Override
            public final void execute(ReadGraphImpl graph, int r) {
                if (this.single == 0) {
                    this.single = r;
                    return;
                }
                this.add(r);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Errors are not supported.", t);
            }
        }
        DirectProcedure directProc = new DirectProcedure(result);
        processor.querySupport.getObjects(graph, this.id, subrelationOf, directProc);
        int size = directProc.size();
        if (size == 0) {
            procedure.finished(graph);
        } else if (size == 1) {
            procedure.execute(graph, directProc.single);
            procedure.finished(graph);
        } else {
            directProc.forEach(new TIntProcedure(){

                public boolean execute(int arg0) {
                    try {
                        procedure.execute(graph, arg0);
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                    return true;
                }
            });
            procedure.finished(graph);
        }
        return this.getResult();
    }

    public String toString() {
        return "DirectSuperRelations[" + this.id + "]";
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        return this.compute(graph, procedure);
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
            }
        });
    }

    private static class Ints {
        private TIntHashSet set = null;
        public int single = 0;

        private Ints() {
        }

        public boolean add(int val) {
            if (this.single == val) {
                return false;
            }
            if (this.single == 0) {
                this.single = val;
                return true;
            }
            if (this.set == null) {
                this.set = new TIntHashSet(4);
            }
            return this.set.add(val);
        }

        public int size() {
            if (this.single == 0) {
                return 0;
            }
            if (this.set == null) {
                return 1;
            }
            return this.set.size() + 1;
        }

        public void forEach(TIntProcedure proc) {
            if (this.single > 0) {
                proc.execute(this.single);
            }
            if (this.set != null) {
                this.set.forEach(proc);
            }
        }
    }
}

