/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.simantics.db.impl.query.CacheEntryBase;

public class CacheCollectionResult
implements Consumer<CacheEntryBase<?>> {
    public static final int LEVELS = 10;
    private int level = 0;
    private int position = -1;
    private int currentLength = 0;
    private int size = 0;
    private ArrayList<CacheEntryBase> currentLevel;
    public ArrayList<CacheEntryBase>[] levels = new ArrayList[10];

    public CacheCollectionResult() {
        int i = 0;
        while (i < 10) {
            this.levels[i] = new ArrayList();
            ++i;
        }
    }

    public void add(CacheEntryBase entry) {
        short level = entry.getLevel();
        if (level < 9) {
            this.levels[level].add(entry);
        } else {
            this.levels[9].add(entry);
        }
        ++this.size;
    }

    public Collection<CacheEntryBase> toCollection() {
        ArrayList<CacheEntryBase> result = new ArrayList<CacheEntryBase>(this.size());
        int i = 0;
        while (i < 10) {
            result.addAll(this.levels[i]);
            ++i;
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public boolean isAtStart() {
        return this.level == 0 && this.position == -1;
    }

    public void restart() {
        this.level = 0;
        this.position = -1;
        this.currentLevel = this.levels[0];
        this.currentLength = this.currentLevel.size();
    }

    public CacheEntryBase next(int maxLevel) {
        ++this.position;
        if (this.position >= this.currentLength) {
            if (this.level == 9) {
                return null;
            }
            if (this.level == maxLevel) {
                return null;
            }
            ++this.level;
            this.position = -1;
            this.currentLevel = this.levels[this.level];
            this.currentLength = this.currentLevel.size();
            return this.next(maxLevel);
        }
        return this.currentLevel.get(this.position);
    }

    public void remove() {
        int lastPosition = this.currentLevel.size() - 1;
        CacheEntryBase last = this.currentLevel.remove(lastPosition);
        if (lastPosition > this.position) {
            this.currentLevel.set(this.position, last);
        }
        --this.currentLength;
        --this.position;
        --this.size;
    }

    public void setLevel(CacheEntryBase current, short level) {
        if (level == current.level) {
            return;
        }
        current.level = level;
        this.remove();
        this.add(current);
    }

    @Override
    public void accept(CacheEntryBase<?> t) {
        this.add(t);
    }
}

