/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.BlockingAsyncMultiProcedure;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.QueryFactoryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncMultiReadEntry<T>
extends CacheEntryBase<AsyncMultiProcedure<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMultiReadEntry.class);
    protected AsyncMultiRead<T> id;

    AsyncMultiReadEntry(AsyncMultiRead<T> request) {
        this.id = request;
    }

    @Override
    int makeHash() {
        return this.id.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.id;
    }

    @Override
    public void discard() {
        super.discard();
        this.id = null;
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void finish(AsyncReadGraph graph) {
        assert (this.isPending());
        AsyncMultiReadEntry asyncMultiReadEntry = this;
        synchronized (asyncMultiReadEntry) {
            this.setReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void except(AsyncReadGraph graph, Throwable t) {
        assert (this.isPending());
        AsyncMultiReadEntry asyncMultiReadEntry = this;
        synchronized (asyncMultiReadEntry) {
            this.except(t);
        }
    }

    public final synchronized void addOrSet(Object item) {
        assert (this.isPending());
        ArrayList value = (ArrayList)this.getResult();
        value.add(item);
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(new ArrayList());
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph) {
                try {
                    BlockingAsyncMultiProcedure proc = new BlockingAsyncMultiProcedure(graph.asyncBarrier, graph, new AsyncMultiProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            AsyncMultiReadEntry.this.addOrSet(result);
                        }

                        public void finished(AsyncReadGraph graph) {
                            AsyncMultiReadEntry.this.finish(graph);
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            AsyncMultiReadEntry.this.except(t);
                        }
                    }, AsyncMultiReadEntry.this.id);
                    AsyncMultiReadEntry.this.id.perform((AsyncReadGraph)graph, proc);
                    proc.get();
                }
                catch (Throwable t) {
                    AsyncMultiReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                QueryCache.remove(processor, AsyncMultiReadEntry.this);
            }

            @Override
            public int type() {
                return 0;
            }

            public String toString() {
                if (AsyncMultiReadEntry.this.id == null) {
                    return "DISCARDED";
                }
                return AsyncMultiReadEntry.this.id.toString() + String.valueOf(AsyncMultiReadEntry.this.statusOrException);
            }
        };
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, AsyncMultiProcedure<T> proc) {
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.exception failed", t);
            }
        } else {
            ArrayList values = (ArrayList)this.getResult();
            for (Object value : values) {
                try {
                    proc.execute((AsyncReadGraph)graph, value);
                }
                catch (Throwable t) {
                    LOGGER.error("performFromCache proc.execute failed", t);
                }
            }
            try {
                proc.finished((AsyncReadGraph)graph);
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.finished failed", t);
            }
        }
        return this.getResult();
    }

    public String toString() {
        if (this.id == null) {
            return "DISCARDED";
        }
        return this.id.toString() + String.valueOf(this.statusOrException);
    }

    public Object compute(ReadGraphImpl graph, AsyncMultiProcedure<T> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.caches.get(this.id);
        return cache.performQuery(graph, this.id, (CacheEntryBase)this, procedure);
    }

    @Override
    public QueryFactoryKey classId() {
        return null;
    }
}

