/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncMultiProcedure;

public class ResultCallWrappedQueryProcedure4<Result>
implements AsyncMultiProcedure<Result> {
    private final ArrayList<Result> result;
    private Throwable exception = null;
    private final AsyncMultiProcedure<Result> procedure;
    private final AtomicBoolean latch;

    public ResultCallWrappedQueryProcedure4(AsyncMultiProcedure<Result> procedure) {
        this.procedure = procedure;
        this.latch = new AtomicBoolean(false);
        this.result = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AsyncReadGraph graph, Result result) {
        try {
            ArrayList<Result> arrayList = this.result;
            synchronized (arrayList) {
                this.result.add(result);
            }
            this.procedure.execute(graph, result);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("AsyncMultiProcedure.execute failed for " + String.valueOf(this.procedure)), (Throwable)t);
        }
    }

    public void finished(AsyncReadGraph graph) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.procedure.finished(graph);
            }
            catch (Throwable t) {
                Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + String.valueOf(this.procedure)), (Throwable)t);
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is finished)");
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.exception = t;
                this.procedure.exception(graph, t);
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + String.valueOf(this.procedure)), (Throwable)throwable);
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is exception)");
        }
    }

    public ArrayList<Result> getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ResultCallWrappedQueryProcedure4[" + String.valueOf(this.procedure) + "]";
    }
}

