/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import org.simantics.db.Resource;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.scl.compiler.elaboration.java.SafeExternalConstant;

public final class ResourceImpl
implements Resource,
SafeExternalConstant {
    public ResourceSupport support;
    public int id;

    public ResourceImpl() {
    }

    public ResourceImpl(ResourceSupport support, int id) {
        assert (id != 0);
        this.support = support;
        this.id = id;
    }

    public final long getResourceId() {
        return this.support.getRandomAccessId(this.id);
    }

    public boolean isPersistent() {
        return this.id > 0;
    }

    public Resource get() {
        return this;
    }

    public int hashCode() {
        return this.id;
    }

    public int getThreadHash() {
        return this.id >>> 16;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ResourceImpl)) {
            return false;
        }
        ResourceImpl r = (ResourceImpl)object;
        return r.id == this.id;
    }

    public boolean equalsResource(Resource other) {
        ResourceImpl r = (ResourceImpl)other;
        return r.id == this.id;
    }

    public int compareTo(Resource o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ResourceImpl) {
            return this.id - ((ResourceImpl)o).id;
        }
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        try {
            long rid = this.getResourceId();
            sb.append("[id=$");
            sb.append(rid);
            sb.append("]");
        }
        catch (Exception exception) {
            sb.append("[internal id=");
            sb.append(this.id);
            sb.append(", persistent resource id failed]");
        }
        return sb.toString();
    }

    public String toString(ClusterSupport support) {
        StringBuilder sb = new StringBuilder(32);
        long rid = this.getResourceId();
        sb.append("[id=$");
        sb.append(rid);
        sb.append("]");
        return sb.toString();
    }
}

