/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.databoard.Bindings;
import org.simantics.db.DevelopmentKeys;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.utils.Development;

import gnu.trove.procedure.TIntProcedure;

public final class SuperTypes extends UnaryQueryPIntSet {

    public SuperTypes(int resource) {
        super(resource);
    }

    @Override
    final public void removeEntry(QueryProcessor provider) {
        QueryCache.remove(provider, this);
    }

    @Override
    public void compute(ReadGraphImpl graph, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        computeForEach(graph, id, this, procedure);
    }

    public static Object computeForEach(ReadGraphImpl graph, int r, SuperTypes entry, final InternalProcedure<IntSet> procedure_) throws DatabaseException {

        if(Development.DEVELOPMENT) {
            if(Development.<Boolean>getProperty(DevelopmentKeys.QUERYPROCESSOR_PERFORM_QUERY, Bindings.BOOLEAN)) {
                Development.log("PQ Supertypes " + r);
            }
        }

        InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;

        QueryProcessor provider = graph.processor;

        final int inherits = provider.getInherits();

        final IntSet result = new IntSet(provider.querySupport);

        final TIntProcedure addToResult = new TIntProcedure() {
            @Override
            public boolean execute(int r) {
                synchronized(result) {
                    result.add(r);
                }
                return true;
            }
        };

        QueryCache.runnerDirectObjects(graph, r, inherits, entry, null, new SyncIntProcedure() {

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                procedure.execute(graph, result);
            }

            @Override
            public void execute(ReadGraphImpl graph, final int i) throws DatabaseException {

                addToResult.execute(i);

                inc();

                QueryCache.runnerSuperTypes(graph, i, entry, null, new InternalProcedure<IntSet>() {

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                        types.forEach(addToResult);
                        dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        procedure.exception(graph, t);
                        dec(graph);
                    }

                });

            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                dec(graph);
            }

        });

        if(entry != null) entry.performFromCache(graph, procedure_);

        return result;

    }

    @Override
    public String toString() {
        return "SuperTypes[" + id + "]";
    }

}
