/*******************************************************************************
 * Copyright (c) 2018, 2025 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *
 * THIS FILE HAS BEEN GENERATED - see CodeGen.java
 *
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;

public class QueryCache extends QueryCacheBase {

    public QueryCache(QueryCaches caches, int cacheKey) {
        super(caches, cacheKey);
    }

    Objects getOrCreateObjects(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        Objects existing = null;
        synchronized(objectsMap) {
            existing = (Objects)objectsMap.get(r1,r2);
            if(existing == null) {
                existing = new Objects(r1,r2);
                existing.setPending(querySupport);
                objectsMap.put(keyR2(r1,r2), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    Objects getOrCreateObjects(int r1, int r2) {
        Objects existing = (Objects)objectsMap.get(r1,r2);
        if(existing == null) {
            existing = new Objects(r1,r2);
            objectsMap.put(keyR2(r1,r2), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, Objects entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.objectsMap) {
            cache.objectsMap.remove(entry.id);
        }
    }
    
    public static void runnerObjects(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, final IntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r1);
        if(parent == null && listener == null && !shouldCache(graph, r1,r2)) {
            if (SINGLE) {
                Objects e = cache.peekObjects(r1,r2);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            Objects.computeForEach(graph, r1,r2, null, procedure);
            return;
        }
        Objects entry = (Objects)cache.getOrCreateObjects(graph, r1,r2);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureObjects;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          Objects.computeForEach(graph, r1,r2, entry, procedure_);
        }
    }
    
    private Objects peekObjects(int r1, int r2) {
        synchronized(objectsMap) {
            return (Objects) objectsMap.get(r1,r2);
        }
    }
    
    Statements getOrCreateStatements(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        Statements existing = null;
        synchronized(statementsMap) {
            existing = (Statements)statementsMap.get(r1,r2);
            if(existing == null) {
                existing = new Statements(r1,r2);
                existing.setPending(querySupport);
                statementsMap.put(keyR2(r1,r2), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    Statements getOrCreateStatements(int r1, int r2) {
        Statements existing = (Statements)statementsMap.get(r1,r2);
        if(existing == null) {
            existing = new Statements(r1,r2);
            statementsMap.put(keyR2(r1,r2), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, Statements entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.statementsMap) {
            cache.statementsMap.remove(entry.id);
        }
    }
    
    public static void runnerStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, final TripleIntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r1);
        if(parent == null && listener == null && !shouldCache(graph, r1,r2)) {
            if (SINGLE) {
                Statements e = cache.peekStatements(r1,r2);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            Statements.computeForEach(graph, r1,r2, null, procedure);
            return;
        }
        Statements entry = (Statements)cache.getOrCreateStatements(graph, r1,r2);
        TripleIntProcedure procedure_ = procedure != null ? procedure : emptyProcedureStatements;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          Statements.computeForEach(graph, r1,r2, entry, procedure_);
        }
    }
    
    private Statements peekStatements(int r1, int r2) {
        synchronized(statementsMap) {
            return (Statements) statementsMap.get(r1,r2);
        }
    }
    
    DirectObjects getOrCreateDirectObjects(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        DirectObjects existing = null;
        synchronized(directObjectsMap) {
            existing = (DirectObjects)directObjectsMap.get(r1,r2);
            if(existing == null) {
                existing = new DirectObjects(r1,r2);
                existing.setPending(querySupport);
                directObjectsMap.put(keyR2(r1,r2), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    DirectObjects getOrCreateDirectObjects(int r1, int r2) {
        DirectObjects existing = (DirectObjects)directObjectsMap.get(r1,r2);
        if(existing == null) {
            existing = new DirectObjects(r1,r2);
            directObjectsMap.put(keyR2(r1,r2), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, DirectObjects entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.directObjectsMap) {
            cache.directObjectsMap.remove(entry.id);
        }
    }
    
    public static void runnerDirectObjects(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, final IntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r1);
        if(parent == null && listener == null && !shouldCache(graph, r1,r2)) {
            if (SINGLE) {
                DirectObjects e = cache.peekDirectObjects(r1,r2);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            DirectObjects.computeForEach(graph, r1,r2, null, procedure);
            return;
        }
        DirectObjects entry = (DirectObjects)cache.getOrCreateDirectObjects(graph, r1,r2);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureDirectObjects;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          DirectObjects.computeForEach(graph, r1,r2, entry, procedure_);
        }
    }
    
    private DirectObjects peekDirectObjects(int r1, int r2) {
        synchronized(directObjectsMap) {
            return (DirectObjects) directObjectsMap.get(r1,r2);
        }
    }
    
    RelationInfoQuery getOrCreateRelationInfoQuery(ReadGraphImpl graph, int r) throws DatabaseException {
        RelationInfoQuery existing = null;
        synchronized(relationInfoQueryMap) {
            existing = (RelationInfoQuery)relationInfoQueryMap.get(r);
            if(existing == null) {
                existing = new RelationInfoQuery(r);
                existing.setPending(querySupport);
                relationInfoQueryMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    RelationInfoQuery getOrCreateRelationInfoQuery(int r) {
        RelationInfoQuery existing = (RelationInfoQuery)relationInfoQueryMap.get(r);
        if(existing == null) {
            existing = new RelationInfoQuery(r);
            relationInfoQueryMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, RelationInfoQuery entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.relationInfoQueryMap) {
            cache.relationInfoQueryMap.remove(entry.id);
        }
    }
    
    public static void runnerRelationInfoQuery(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<RelationInfo> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                RelationInfoQuery e = cache.peekRelationInfoQuery(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            RelationInfoQuery.computeForEach(graph, r, null, procedure);
            return;
        }
        RelationInfoQuery entry = (RelationInfoQuery)cache.getOrCreateRelationInfoQuery(graph, r);
        InternalProcedure<RelationInfo> procedure_ = procedure != null ? procedure : emptyProcedureRelationInfoQuery;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          RelationInfoQuery.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private RelationInfoQuery peekRelationInfoQuery(int r) {
        synchronized(relationInfoQueryMap) {
            return (RelationInfoQuery) relationInfoQueryMap.get(r);
        }
    }
    
    URIToResource getOrCreateURIToResource(ReadGraphImpl graph, String id) throws DatabaseException {
        URIToResource existing = null;
        synchronized(uRIToResourceMap) {
            existing = (URIToResource)uRIToResourceMap.get(id);
            if(existing == null) {
                existing = new URIToResource(id);
                existing.setPending(querySupport);
                uRIToResourceMap.put(keyID(id), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    URIToResource getOrCreateURIToResource(String id) {
        URIToResource existing = (URIToResource)uRIToResourceMap.get(id);
        if(existing == null) {
            existing = new URIToResource(id);
            uRIToResourceMap.put(keyID(id), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, URIToResource entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.uRIToResourceMap) {
            cache.uRIToResourceMap.remove(entry.id);
        }
    }
    
    public static void runnerURIToResource(ReadGraphImpl graph, String id, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<Integer> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(id);
        if(parent == null && listener == null && !shouldCache(graph, id)) {
            if (SINGLE) {
                URIToResource e = cache.peekURIToResource(id);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            URIToResource.computeForEach(graph, id, null, procedure);
            return;
        }
        URIToResource entry = (URIToResource)cache.getOrCreateURIToResource(graph, id);
        InternalProcedure<Integer> procedure_ = procedure != null ? procedure : emptyProcedureURIToResource;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          URIToResource.computeForEach(graph, id, entry, procedure_);
        }
    }
    
    private URIToResource peekURIToResource(String id) {
        synchronized(uRIToResourceMap) {
            return (URIToResource) uRIToResourceMap.get(id);
        }
    }
    
    ValueQuery getOrCreateValueQuery(ReadGraphImpl graph, int r) throws DatabaseException {
        ValueQuery existing = null;
        synchronized(valueQueryMap) {
            existing = (ValueQuery)valueQueryMap.get(r);
            if(existing == null) {
                existing = new ValueQuery(r);
                existing.setPending(querySupport);
                valueQueryMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    ValueQuery getOrCreateValueQuery(int r) {
        ValueQuery existing = (ValueQuery)valueQueryMap.get(r);
        if(existing == null) {
            existing = new ValueQuery(r);
            valueQueryMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, ValueQuery entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.valueQueryMap) {
            cache.valueQueryMap.remove(entry.id);
        }
    }
    
    public static void runnerValueQuery(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<byte[]> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                ValueQuery e = cache.peekValueQuery(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            ValueQuery.computeForEach(graph, r, null, procedure);
            return;
        }
        ValueQuery entry = (ValueQuery)cache.getOrCreateValueQuery(graph, r);
        InternalProcedure<byte[]> procedure_ = procedure != null ? procedure : emptyProcedureValueQuery;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          ValueQuery.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private ValueQuery peekValueQuery(int r) {
        synchronized(valueQueryMap) {
            return (ValueQuery) valueQueryMap.get(r);
        }
    }
    
    OrderedSet getOrCreateOrderedSet(ReadGraphImpl graph, int r) throws DatabaseException {
        OrderedSet existing = null;
        synchronized(orderedSetMap) {
            existing = (OrderedSet)orderedSetMap.get(r);
            if(existing == null) {
                existing = new OrderedSet(r);
                existing.setPending(querySupport);
                orderedSetMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    OrderedSet getOrCreateOrderedSet(int r) {
        OrderedSet existing = (OrderedSet)orderedSetMap.get(r);
        if(existing == null) {
            existing = new OrderedSet(r);
            orderedSetMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, OrderedSet entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.orderedSetMap) {
            cache.orderedSetMap.remove(entry.id);
        }
    }
    
    public static void runnerOrderedSet(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final IntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                OrderedSet e = cache.peekOrderedSet(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            OrderedSet.computeForEach(graph, r, null, procedure);
            return;
        }
        OrderedSet entry = (OrderedSet)cache.getOrCreateOrderedSet(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureOrderedSet;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          OrderedSet.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private OrderedSet peekOrderedSet(int r) {
        synchronized(orderedSetMap) {
            return (OrderedSet) orderedSetMap.get(r);
        }
    }
    
    PrincipalTypes getOrCreatePrincipalTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        PrincipalTypes existing = null;
        synchronized(principalTypesMap) {
            existing = (PrincipalTypes)principalTypesMap.get(r);
            if(existing == null) {
                existing = new PrincipalTypes(r);
                existing.setPending(querySupport);
                principalTypesMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    PrincipalTypes getOrCreatePrincipalTypes(int r) {
        PrincipalTypes existing = (PrincipalTypes)principalTypesMap.get(r);
        if(existing == null) {
            existing = new PrincipalTypes(r);
            principalTypesMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, PrincipalTypes entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.principalTypesMap) {
            cache.principalTypesMap.remove(entry.id);
        }
    }
    
    public static void runnerPrincipalTypes(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final IntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                PrincipalTypes e = cache.peekPrincipalTypes(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            PrincipalTypes.computeForEach(graph, r, null, procedure);
            return;
        }
        PrincipalTypes entry = (PrincipalTypes)cache.getOrCreatePrincipalTypes(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedurePrincipalTypes;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          PrincipalTypes.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private PrincipalTypes peekPrincipalTypes(int r) {
        synchronized(principalTypesMap) {
            return (PrincipalTypes) principalTypesMap.get(r);
        }
    }
    
    DirectPredicates getOrCreateDirectPredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        DirectPredicates existing = null;
        synchronized(directPredicatesMap) {
            existing = (DirectPredicates)directPredicatesMap.get(r);
            if(existing == null) {
                existing = new DirectPredicates(r);
                existing.setPending(querySupport);
                directPredicatesMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    DirectPredicates getOrCreateDirectPredicates(int r) {
        DirectPredicates existing = (DirectPredicates)directPredicatesMap.get(r);
        if(existing == null) {
            existing = new DirectPredicates(r);
            directPredicatesMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, DirectPredicates entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.directPredicatesMap) {
            cache.directPredicatesMap.remove(entry.id);
        }
    }
    
    public static void runnerDirectPredicates(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                DirectPredicates e = cache.peekDirectPredicates(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            DirectPredicates.computeForEach(graph, r, null, procedure);
            return;
        }
        DirectPredicates entry = (DirectPredicates)cache.getOrCreateDirectPredicates(graph, r);
        InternalProcedure<IntSet> procedure_ = procedure != null ? procedure : emptyProcedureDirectPredicates;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          DirectPredicates.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private DirectPredicates peekDirectPredicates(int r) {
        synchronized(directPredicatesMap) {
            return (DirectPredicates) directPredicatesMap.get(r);
        }
    }
    
    Predicates getOrCreatePredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        Predicates existing = null;
        synchronized(predicatesMap) {
            existing = (Predicates)predicatesMap.get(r);
            if(existing == null) {
                existing = new Predicates(r);
                existing.setPending(querySupport);
                predicatesMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    Predicates getOrCreatePredicates(int r) {
        Predicates existing = (Predicates)predicatesMap.get(r);
        if(existing == null) {
            existing = new Predicates(r);
            predicatesMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, Predicates entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.predicatesMap) {
            cache.predicatesMap.remove(entry.id);
        }
    }
    
    public static void runnerPredicates(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                Predicates e = cache.peekPredicates(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            Predicates.computeForEach(graph, r, null, procedure);
            return;
        }
        Predicates entry = (Predicates)cache.getOrCreatePredicates(graph, r);
        InternalProcedure<IntSet> procedure_ = procedure != null ? procedure : emptyProcedurePredicates;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          Predicates.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private Predicates peekPredicates(int r) {
        synchronized(predicatesMap) {
            return (Predicates) predicatesMap.get(r);
        }
    }
    
    Types getOrCreateTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        Types existing = null;
        synchronized(typesMap) {
            existing = (Types)typesMap.get(r);
            if(existing == null) {
                existing = new Types(r);
                existing.setPending(querySupport);
                typesMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    Types getOrCreateTypes(int r) {
        Types existing = (Types)typesMap.get(r);
        if(existing == null) {
            existing = new Types(r);
            typesMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, Types entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.typesMap) {
            cache.typesMap.remove(entry.id);
        }
    }
    
    public static void runnerTypes(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                Types e = cache.peekTypes(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            Types.computeForEach(graph, r, null, procedure);
            return;
        }
        Types entry = (Types)cache.getOrCreateTypes(graph, r);
        InternalProcedure<IntSet> procedure_ = procedure != null ? procedure : emptyProcedureTypes;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          Types.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private Types peekTypes(int r) {
        synchronized(typesMap) {
            return (Types) typesMap.get(r);
        }
    }
    
    ChildMap getOrCreateChildMap(ReadGraphImpl graph, int r) throws DatabaseException {
        ChildMap existing = null;
        synchronized(childMapMap) {
            existing = (ChildMap)childMapMap.get(r);
            if(existing == null) {
                existing = new ChildMap(r);
                existing.setPending(querySupport);
                childMapMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    ChildMap getOrCreateChildMap(int r) {
        ChildMap existing = (ChildMap)childMapMap.get(r);
        if(existing == null) {
            existing = new ChildMap(r);
            childMapMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, ChildMap entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.childMapMap) {
            cache.childMapMap.remove(entry.id);
        }
    }
    
    public static void runnerChildMap(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<ObjectResourceIdMap<String>> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                ChildMap e = cache.peekChildMap(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            ChildMap.computeForEach(graph, r, null, procedure);
            return;
        }
        ChildMap entry = (ChildMap)cache.getOrCreateChildMap(graph, r);
        InternalProcedure<ObjectResourceIdMap<String>> procedure_ = procedure != null ? procedure : emptyProcedureChildMap;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          ChildMap.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private ChildMap peekChildMap(int r) {
        synchronized(childMapMap) {
            return (ChildMap) childMapMap.get(r);
        }
    }
    
    TypeHierarchy getOrCreateTypeHierarchy(ReadGraphImpl graph, int r) throws DatabaseException {
        TypeHierarchy existing = null;
        synchronized(typeHierarchyMap) {
            existing = (TypeHierarchy)typeHierarchyMap.get(r);
            if(existing == null) {
                existing = new TypeHierarchy(r);
                existing.setPending(querySupport);
                typeHierarchyMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    TypeHierarchy getOrCreateTypeHierarchy(int r) {
        TypeHierarchy existing = (TypeHierarchy)typeHierarchyMap.get(r);
        if(existing == null) {
            existing = new TypeHierarchy(r);
            typeHierarchyMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, TypeHierarchy entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.typeHierarchyMap) {
            cache.typeHierarchyMap.remove(entry.id);
        }
    }
    
    public static void runnerTypeHierarchy(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                TypeHierarchy e = cache.peekTypeHierarchy(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            TypeHierarchy.computeForEach(graph, r, null, procedure);
            return;
        }
        TypeHierarchy entry = (TypeHierarchy)cache.getOrCreateTypeHierarchy(graph, r);
        InternalProcedure<IntSet> procedure_ = procedure != null ? procedure : emptyProcedureTypeHierarchy;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          TypeHierarchy.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private TypeHierarchy peekTypeHierarchy(int r) {
        synchronized(typeHierarchyMap) {
            return (TypeHierarchy) typeHierarchyMap.get(r);
        }
    }
    
    SuperTypes getOrCreateSuperTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        SuperTypes existing = null;
        synchronized(superTypesMap) {
            existing = (SuperTypes)superTypesMap.get(r);
            if(existing == null) {
                existing = new SuperTypes(r);
                existing.setPending(querySupport);
                superTypesMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    SuperTypes getOrCreateSuperTypes(int r) {
        SuperTypes existing = (SuperTypes)superTypesMap.get(r);
        if(existing == null) {
            existing = new SuperTypes(r);
            superTypesMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, SuperTypes entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.superTypesMap) {
            cache.superTypesMap.remove(entry.id);
        }
    }
    
    public static void runnerSuperTypes(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                SuperTypes e = cache.peekSuperTypes(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            SuperTypes.computeForEach(graph, r, null, procedure);
            return;
        }
        SuperTypes entry = (SuperTypes)cache.getOrCreateSuperTypes(graph, r);
        InternalProcedure<IntSet> procedure_ = procedure != null ? procedure : emptyProcedureSuperTypes;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          SuperTypes.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private SuperTypes peekSuperTypes(int r) {
        synchronized(superTypesMap) {
            return (SuperTypes) superTypesMap.get(r);
        }
    }
    
    SuperRelations getOrCreateSuperRelations(ReadGraphImpl graph, int r) throws DatabaseException {
        SuperRelations existing = null;
        synchronized(superRelationsMap) {
            existing = (SuperRelations)superRelationsMap.get(r);
            if(existing == null) {
                existing = new SuperRelations(r);
                existing.setPending(querySupport);
                superRelationsMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    SuperRelations getOrCreateSuperRelations(int r) {
        SuperRelations existing = (SuperRelations)superRelationsMap.get(r);
        if(existing == null) {
            existing = new SuperRelations(r);
            superRelationsMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, SuperRelations entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.superRelationsMap) {
            cache.superRelationsMap.remove(entry.id);
        }
    }
    
    public static void runnerSuperRelations(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        if(parent == null && listener == null && !shouldCache(graph, r)) {
            if (SINGLE) {
                SuperRelations e = cache.peekSuperRelations(r);
                if (e != null && e.isReady()) {
                    e.performFromCache(graph, procedure);
                    return;
                }
            }
            SuperRelations.computeForEach(graph, r, null, procedure);
            return;
        }
        SuperRelations entry = (SuperRelations)cache.getOrCreateSuperRelations(graph, r);
        InternalProcedure<IntSet> procedure_ = procedure != null ? procedure : emptyProcedureSuperRelations;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          SuperRelations.computeForEach(graph, r, entry, procedure_);
        }
    }
    
    private SuperRelations peekSuperRelations(int r) {
        synchronized(superRelationsMap) {
            return (SuperRelations) superRelationsMap.get(r);
        }
    }
    
    AssertedPredicates getOrCreateAssertedPredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        AssertedPredicates existing = null;
        synchronized(assertedPredicatesMap) {
            existing = (AssertedPredicates)assertedPredicatesMap.get(r);
            if(existing == null) {
                existing = new AssertedPredicates(r);
                existing.setPending(querySupport);
                assertedPredicatesMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    AssertedPredicates getOrCreateAssertedPredicates(int r) {
        AssertedPredicates existing = (AssertedPredicates)assertedPredicatesMap.get(r);
        if(existing == null) {
            existing = new AssertedPredicates(r);
            assertedPredicatesMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, AssertedPredicates entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.assertedPredicatesMap) {
            cache.assertedPredicatesMap.remove(entry.id);
        }
    }
    
    public static void runnerAssertedPredicates(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final IntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        AssertedPredicates entry = (AssertedPredicates)cache.getOrCreateAssertedPredicates(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureAssertedPredicates;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.compute(graph, procedure_);
        }
    }
    
    private AssertedPredicates peekAssertedPredicates(int r) {
        synchronized(assertedPredicatesMap) {
            return (AssertedPredicates) assertedPredicatesMap.get(r);
        }
    }
    
    AssertedStatements getOrCreateAssertedStatements(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        AssertedStatements existing = null;
        synchronized(assertedStatementsMap) {
            existing = (AssertedStatements)assertedStatementsMap.get(r1,r2);
            if(existing == null) {
                existing = new AssertedStatements(r1,r2);
                existing.setPending(querySupport);
                assertedStatementsMap.put(keyR2(r1,r2), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    AssertedStatements getOrCreateAssertedStatements(int r1, int r2) {
        AssertedStatements existing = (AssertedStatements)assertedStatementsMap.get(r1,r2);
        if(existing == null) {
            existing = new AssertedStatements(r1,r2);
            assertedStatementsMap.put(keyR2(r1,r2), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, AssertedStatements entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.assertedStatementsMap) {
            cache.assertedStatementsMap.remove(entry.id);
        }
    }
    
    public static void runnerAssertedStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, final TripleIntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r1);
        AssertedStatements entry = (AssertedStatements)cache.getOrCreateAssertedStatements(graph, r1,r2);
        TripleIntProcedure procedure_ = procedure != null ? procedure : emptyProcedureAssertedStatements;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.compute(graph, procedure_);
        }
    }
    
    private AssertedStatements peekAssertedStatements(int r1, int r2) {
        synchronized(assertedStatementsMap) {
            return (AssertedStatements) assertedStatementsMap.get(r1,r2);
        }
    }
    
    DirectSuperRelations getOrCreateDirectSuperRelations(ReadGraphImpl graph, int r) throws DatabaseException {
        DirectSuperRelations existing = null;
        synchronized(directSuperRelationsMap) {
            existing = (DirectSuperRelations)directSuperRelationsMap.get(r);
            if(existing == null) {
                existing = new DirectSuperRelations(r);
                existing.setPending(querySupport);
                directSuperRelationsMap.put(keyR(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    DirectSuperRelations getOrCreateDirectSuperRelations(int r) {
        DirectSuperRelations existing = (DirectSuperRelations)directSuperRelationsMap.get(r);
        if(existing == null) {
            existing = new DirectSuperRelations(r);
            directSuperRelationsMap.put(keyR(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, DirectSuperRelations entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.directSuperRelationsMap) {
            cache.directSuperRelationsMap.remove(entry.id);
        }
    }
    
    public static void runnerDirectSuperRelations(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, final IntProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        DirectSuperRelations entry = (DirectSuperRelations)cache.getOrCreateDirectSuperRelations(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureDirectSuperRelations;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.compute(graph, procedure_);
        }
    }
    
    private DirectSuperRelations peekDirectSuperRelations(int r) {
        synchronized(directSuperRelationsMap) {
            return (DirectSuperRelations) directSuperRelationsMap.get(r);
        }
    }
    
    MultiReadEntry getOrCreateMultiReadEntry(ReadGraphImpl graph, MultiRead<?> r) throws DatabaseException {
        MultiReadEntry existing = null;
        synchronized(multiReadEntryMap) {
            existing = (MultiReadEntry)multiReadEntryMap.get(r);
            if(existing == null) {
                existing = new MultiReadEntry(r);
                existing.setPending(querySupport);
                multiReadEntryMap.put(id(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    MultiReadEntry getOrCreateMultiReadEntry(MultiRead<?> r) {
        MultiReadEntry existing = (MultiReadEntry)multiReadEntryMap.get(r);
        if(existing == null) {
            existing = new MultiReadEntry(r);
            multiReadEntryMap.put(id(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, MultiReadEntry entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.multiReadEntryMap) {
            cache.multiReadEntryMap.remove(entry.id);
        }
    }
    
    public static void runnerMultiReadEntry(ReadGraphImpl graph, MultiRead<?> r, CacheEntry<?> parent, ListenerBase listener, final SyncMultiProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        MultiReadEntry entry = (MultiReadEntry)cache.getOrCreateMultiReadEntry(graph, r);
        SyncMultiProcedure procedure_ = procedure != null ? procedure : emptyProcedureMultiReadEntry;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.compute(graph, procedure_);
        }
    }
    
    private MultiReadEntry peekMultiReadEntry(MultiRead<?> r) {
        synchronized(multiReadEntryMap) {
            return (MultiReadEntry) multiReadEntryMap.get(r);
        }
    }
    
    AsyncMultiReadEntry getOrCreateAsyncMultiReadEntry(ReadGraphImpl graph, AsyncMultiRead<?> r) throws DatabaseException {
        AsyncMultiReadEntry existing = null;
        synchronized(asyncMultiReadEntryMap) {
            existing = (AsyncMultiReadEntry)asyncMultiReadEntryMap.get(r);
            if(existing == null) {
                existing = new AsyncMultiReadEntry(r);
                existing.setPending(querySupport);
                asyncMultiReadEntryMap.put(id(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    AsyncMultiReadEntry getOrCreateAsyncMultiReadEntry(AsyncMultiRead<?> r) {
        AsyncMultiReadEntry existing = (AsyncMultiReadEntry)asyncMultiReadEntryMap.get(r);
        if(existing == null) {
            existing = new AsyncMultiReadEntry(r);
            asyncMultiReadEntryMap.put(id(r), existing);
            updates.incrementAndGet();
            size.incrementAndGet();
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, AsyncMultiReadEntry entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.asyncMultiReadEntryMap) {
            cache.asyncMultiReadEntryMap.remove(entry.id);
        }
    }
    
    public static void runnerAsyncMultiReadEntry(ReadGraphImpl graph, AsyncMultiRead<?> r, CacheEntry<?> parent, ListenerBase listener, final AsyncMultiProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        AsyncMultiReadEntry entry = (AsyncMultiReadEntry)cache.getOrCreateAsyncMultiReadEntry(graph, r);
        AsyncMultiProcedure procedure_ = procedure != null ? procedure : emptyProcedureAsyncMultiReadEntry;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.compute(graph, procedure_);
        }
    }
    
    private AsyncMultiReadEntry peekAsyncMultiReadEntry(AsyncMultiRead<?> r) {
        synchronized(asyncMultiReadEntryMap) {
            return (AsyncMultiReadEntry) asyncMultiReadEntryMap.get(r);
        }
    }
    
    ExternalReadEntry getOrCreateExternalReadEntry(ReadGraphImpl graph, ExternalRead<?> r) throws DatabaseException {
        ExternalReadEntry existing = null;
        synchronized(externalReadEntryMap) {
            existing = (ExternalReadEntry)externalReadEntryMap.get(r);
            if(existing == null) {
                existing = new ExternalReadEntry(r, graph);
                existing.setPending(querySupport);
                externalReadEntryMap.put(id(r), existing);
                updates.incrementAndGet();
                size.incrementAndGet();
                return existing;
            }
            if(existing.requiresComputation()) {
                existing.setPending(querySupport);
                return existing;
            }
        }
        if(existing.isPending()) {
          waitPending(graph, existing);
        }
        return existing;
    }
    
    static void remove(QueryProcessor processor, ExternalReadEntry entry) {
        QueryCache cache = processor.caches.get(entry.id);
        synchronized(cache.externalReadEntryMap) {
            cache.externalReadEntryMap.remove(entry.id);
        }
    }
    
    public static void runnerExternalReadEntry(ReadGraphImpl graph, ExternalRead<?> r, CacheEntry<?> parent, ListenerBase listener, final AsyncProcedure procedure) throws DatabaseException {
        QueryCache cache  = graph.processor.caches.get(r);
        ExternalReadEntry entry = (ExternalReadEntry)cache.getOrCreateExternalReadEntry(graph, r);
        AsyncProcedure procedure_ = procedure != null ? procedure : emptyProcedureExternalReadEntry;
        if(entry.isReady()) {
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.performFromCache(graph, procedure_);
        }
        else {
          assert(entry.isPending());
          graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
          entry.compute(graph, procedure_);
        }
    }
    
    private ExternalReadEntry peekExternalReadEntry(ExternalRead<?> r) {
        synchronized(externalReadEntryMap) {
            return (ExternalReadEntry) externalReadEntryMap.get(r);
        }
    }
    
}
