/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.impl.graph;

import org.simantics.db.MetadataI;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteResult;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ByteReader;

public interface WriteSupport extends MetadataI {
    
    void claim(VirtualGraph provider, int subject, int predicate, int object)
    throws ServiceException;

    void claim(VirtualGraph provider, Resource subject, Resource predicate, Resource object)
    throws ServiceException;

    boolean removeStatement(VirtualGraph provider, Resource subject, Resource predicate, Resource object)
    throws ServiceException;
    
    void claimValue(VirtualGraph provider, int resource, byte[] value, int length) throws DatabaseException;
    void claimValue(VirtualGraph provider, Resource resource, byte[] value) throws DatabaseException;
    void claimValue(VirtualGraph provider, Resource resource, ByteReader reader, int amount) throws DatabaseException;
    
    void denyValue(VirtualGraph provider, Resource resource) throws ServiceException;

    void setValue(VirtualGraph provider, Resource resource, byte[] value) throws ServiceException;
    
    Resource createResource(VirtualGraph provider)
    throws DatabaseException;
    
    Resource createResource(VirtualGraph provider, long clusterId)
    throws DatabaseException;

    Resource createResource(VirtualGraph provider, Resource clusterSet)
    throws DatabaseException;

    void createClusterSet(VirtualGraph provider, Resource clusterSet, boolean immutable)
    throws DatabaseException;

    void setClusterSetImmutability(VirtualGraph provider, Resource clusterSet, boolean immutable)
    throws DatabaseException;

    boolean hasClusterSet(VirtualGraph provider, Resource clusterSet)
    throws ServiceException;

    Resource setDefaultClusterSet(Resource clusterSet)
    throws ServiceException;

    void setupClusters() throws DatabaseException;

    void performWriteRequest(WriteGraph graph, Write request) throws DatabaseException;    
    <T> T performWriteRequest(WriteGraph graph, WriteResult<T> request) throws DatabaseException;    
    void performWriteRequest(WriteGraph graph, WriteOnly request) throws DatabaseException;    
    
    boolean writeOnly();

    void flush(boolean intermediate);
    void flushCluster();
    void flushCluster(Resource r);

    void gc();
    
    void commitDone(WriteTraits writeTraits, long csid);
    void clearUndoList(WriteTraits writeTraits);
    void startUndo();
    /**
     * @return size of meta data before clearing.
     */
    int clearMetadata();
}
