package org.simantics.db.impl.graph;

import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.SyncMultiProcedure;

public class MultiIntProcedure implements IntProcedure {

	final private SyncMultiProcedure<Resource> procedure;
	final private ReadGraphImpl impl;
	final private QuerySupport support;
	
	public MultiIntProcedure(SyncMultiProcedure<Resource> procedure, ReadGraphImpl impl, QuerySupport support) {
		this.procedure = procedure;
		this.impl = impl;
		this.support = support;
	}
	
	@Override
	public void execute(ReadGraphImpl graph, int i) {
		try {
			procedure.execute(graph, support.getResource(i));
		} catch (Throwable t2) {
    		Logger.defaultLogError(t2);
		}
	}

	@Override
	public void finished(ReadGraphImpl graph) {
		try {
			procedure.finished(graph);
//			impl.state.barrier.dec(this);
		} catch (Throwable t2) {
    		Logger.defaultLogError(t2);
		}
	}

	@Override
	public void exception(ReadGraphImpl graph, Throwable t) {
		try {
			procedure.exception(graph, t);
		} catch (Throwable t2) {
    		Logger.defaultLogError(t2);
		}
//		impl.state.barrier.dec("ReadGraphSupportImpl.516");
	}

	@Override
	public String toString() {
		return "forEachObject with " + procedure;
	}
	
}