/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.impl;

import org.simantics.db.service.ClusteringSupport;

abstract public class ClusteringSupportImpl implements ClusteringSupport {

	abstract public long clusterIdByResourceKey(int resourceKey);
	abstract public long clusterIdByClusterKey(int clusterKey);
	abstract public int clusterKeyByClusterId(long clusterId);
	abstract public boolean isImmutableClusterKey(int clusterKey);
	abstract public boolean isImmutableClusterId(long clusterId);

}
