package org.simantics.db.impl.support;

import java.util.concurrent.Semaphore;
import java.util.function.Consumer;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.DelayedWriteResult;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteOnlyResult;
import org.simantics.db.request.WriteResult;

/**
 * @author Tuukka Lehtonen
 */
public interface WriteRequestScheduleSupport {

    <T> void scheduleRequest(DelayedWrite request, Consumer<DatabaseException> callback, Semaphore notify,
            Boolean combine);

    <T> void scheduleRequest(DelayedWriteResult<T> request, Procedure<T> procedure, Semaphore notify, Boolean combine);

    <T> void scheduleRequest(Write request, Consumer<DatabaseException> callback, Semaphore notify, Boolean combine);

    <T> void scheduleRequest(WriteOnly request, Consumer<DatabaseException> callback, Semaphore notify, Boolean combine);

    <T> void scheduleRequest(WriteOnlyResult<T> request, Procedure<T> callback, Semaphore notify, Boolean combine);

    <T> void scheduleRequest(WriteResult<T> request, Procedure<T> procedure, Semaphore notify, Boolean combine);

}