/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusteringSupportImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.request.RequestFlags;

import gnu.trove.ext.IdContainer;

public abstract class UnaryQuery<Procedure> extends CacheEntryBase<Procedure> implements Query, IdContainer {

    final public int id;

    public UnaryQuery(int r) {
        assert(r != 0);
        this.id = r;
    }
    
    @Override
    int makeHash() {
    	return id;
    }
    
    final public int primaryId() {
        return id;
    }
    
    @Override
    public int type() {
        return RequestFlags.INVALIDATE;
    }
    
    @Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        UnaryQuery<?> other = (UnaryQuery<?>)object;
        return id == other.id;
    }
    
    @Override
    final public Query getQuery() {
        assert(!isDiscarded());
        return this;
    }
    
    abstract public void removeEntry(QueryProcessor provider);
	
    public Object get(ReadGraphImpl graph, Procedure procedure) throws Throwable {
        if(procedure != null) {
            performFromCache(graph, procedure);
        } else {
            checkAndThrow();
        }
        return getResult();
    }
    
    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
        return graph.processor.isImmutableForReading(id);
    }
    
    @Override
    public long cacheIdImpl(ClusteringSupportImpl support) {
        return support.clusterIdByResourceKey(id) << 1;
    }
    
    @Override
    public void serializeKey(QuerySerializerImpl serializer) {
        serializer.addResource(id);
    }
    
}
