package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.impl.query.QueryProcessor.SessionTask;

/*
 * Support class for queuing pending tasks to be executed when result gets ready
 */
public class PendingTaskSupport {

    private ArrayList<SessionTask> pendingTasks;
    private IPending pending;
    
    public PendingTaskSupport(IPending pending) {
        this.pending = pending;
    }
    
    /*
     * We assume here that the associated IPending performs this atomically
     * The caller is responsible for execution of the returned task after the critical section
     */
    public boolean executeWhenResultIsAvailable(SessionTask task) {
        if(pending.isPending()) {
            if(pendingTasks == null)
                pendingTasks = new ArrayList<SessionTask>();
            pendingTasks.add(task);
            return false;
        } else {
            return true;
        }
    }

    /*
     * We assume here that the associated IPending performs this atomically after changing the pending result
     * The caller is responsible for execution of the returned task after the critical section
     */
    public Collection<SessionTask> executePending() {
        ArrayList<SessionTask> ret = pendingTasks;
        pendingTasks = null;
        return ret;
    }

}
