package org.simantics.db.impl.query;

import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.hash.TLongHashSet;

final public class ObjectUpdateSet {

	private long first = 0;
	public TLongHashSet rest = new TLongHashSet();
	
	public int size() {
		if(first != 0) return 1;
		else return rest.size();
	}
	
	public long getFirst() {
		return first;
	}
	
	public void add(long l) {
		if(first == 0) {
			if(rest.isEmpty()) {
				first = l;
			} else {
				rest.add(l);
			}
		} else {
			if(l == first) return;
			rest.add(first);
			rest.add(l);
			first = 0;
		}
	}
	
	public void clear() {
		first = 0;
		if(!rest.isEmpty()) {
			rest = new TLongHashSet();
			//System.err.println("new rest!");
		}
		//rest.clear();
	}
	
	public void forEach(TLongProcedure proc) {
		if(first != 0) {
			proc.execute(first);
		} else {
			rest.forEach(proc);
		}
	}
	
}
