/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QueryDeserializer;
import org.simantics.db.request.QueryFactory;

public class ChildMapFactory implements QueryFactory {

	@SuppressWarnings("unchecked")
	@Override
	public <T> T readKey(QueryDeserializer deserializer) throws DatabaseException {
		return (T)((QueryDeserializerImpl)deserializer).readChildMap();
	}

	@Override
	public Object readValue(QueryDeserializer deserializer_, Object key) throws DatabaseException {
		QueryDeserializerImpl deserializer = (QueryDeserializerImpl)deserializer_;
		ObjectResourceIdMap<String> map = deserializer.createChildMap();
		int size = deserializer.readLE4();
		for(int i=0;i<size;i++) {
			String k = deserializer.readString();
			int r2 = deserializer.readResourceI();
			map.putId(k, r2);
		}
		return map;
	}

}
