package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public class CacheCollectionResult implements Consumer<CacheEntryBase<?>> {
	public static final int LEVELS = 10;
	private int level = 0;
	private int position = -1;
	private int currentLength = 0;
	private int size = 0;
	private ArrayList<CacheEntryBase> currentLevel;
	public ArrayList<CacheEntryBase> levels[] = new ArrayList[LEVELS];
	public CacheCollectionResult() {
		for(int i=0;i<LEVELS;i++) {
			levels[i] = new ArrayList<CacheEntryBase>();
		}
	}
	public void add(CacheEntryBase entry) {
		short level = entry.getLevel();
		if(level < (LEVELS-1)) levels[level].add(entry);
		else levels[(LEVELS-1)].add(entry);
		size++;
	}
	public Collection<CacheEntryBase> toCollection() {
		ArrayList<CacheEntryBase> result = new ArrayList<CacheEntryBase>(size());
		for(int i=0;i<LEVELS;i++)
			result.addAll(levels[i]);
		return result;
	}
	public int size() {
		return size;
	}
	public boolean isAtStart() {
		return level == 0 && position == -1;
	}
	public void restart() {
		level = 0;
		position = -1;
		currentLevel = levels[0];
		currentLength = currentLevel.size();
	}
	public CacheEntryBase next(int maxLevel) {
		//System.err.println("next " + position + " " + level);
		position++;
		if(position >= currentLength) {
			if(level == (LEVELS-1)) return null;
			if(level == maxLevel) return null;
			level++;
			position=-1;
			currentLevel = levels[level];
			currentLength = currentLevel.size();
			return next(maxLevel);
		}
		return currentLevel.get(position);
	}
	public void remove() {
		int lastPosition = currentLevel.size()-1;
		CacheEntryBase last = currentLevel.remove(lastPosition);
		if(lastPosition > position) {
			currentLevel.set(position, last);
		}
		currentLength--;
		position--;
		size--;
	}
	public void setLevel(CacheEntryBase current, short level) {
		if(level == current.level)
			return;
		current.level = level;
		remove();
		add(current);
	}
	@Override
	public void accept(CacheEntryBase<?> t) {
		add(t);
	}
}