/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QueryDeserializer;
import org.simantics.db.request.QueryFactory;

public class AssertedPredicatesFactory implements QueryFactory {

	@SuppressWarnings("unchecked")
	@Override
	public <T> T readKey(QueryDeserializer deserializer) throws DatabaseException {
		return (T)((QueryDeserializerImpl)deserializer).readAssertedPredicates();
	}

	@Override
	public Object readValue(QueryDeserializer deserializer, Object key) throws DatabaseException {
		return IntArray.deserialize(deserializer);
	}

}
