/*******************************************************************************
 * Copyright (c) 2025 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

public class AccessTime {

	private long last = 0;

	private static AccessTime INSTANCE = new AccessTime();

	private AccessTime() {

	}

	public static AccessTime getInstance() {
		return INSTANCE;
	}

	public synchronized long getAccessTime() {
		long result = System.nanoTime();
		last = Math.max(result, last+1);
		return last;
	}

}
