/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.procedure;

import java.util.concurrent.atomic.AtomicBoolean;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.impl.query.QueryProcessor.AsyncBarrier;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;

public class ResultCallWrappedSingleQueryProcedure45<Result> implements AsyncProcedure<Result> {

    private Result result = null;
    private Throwable exception = null;
    final private Procedure<Result> procedure;
    final private AsyncBarrier barrier;
    final private AtomicBoolean latch;
    
    public ResultCallWrappedSingleQueryProcedure45(Procedure<Result> procedure, AsyncBarrier barrier) {
    	assert(procedure != null);
        this.procedure = procedure;
        this.barrier = barrier;
        latch = new AtomicBoolean(false);
    }
    
    @Override
    public void execute(AsyncReadGraph graph, Result result) {
        this.result = result;
        if(latch.compareAndSet(false, true)) {
        	try {
        		procedure.execute(result);
        	} catch (Throwable throwable) {
            	Logger.defaultLogError("AsyncProcedure.execute threw for " + procedure, throwable);
        	} finally {
        		barrier.dec();
        	}
        } else {
        	Logger.defaultLogError("Procedure was called many times (this time is execute)");
        }
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        this.exception = t;
        if(latch.compareAndSet(false, true)) {
        	try {
        		procedure.exception(t);
        	} catch (Throwable throwable) {
            	Logger.defaultLogError("AsyncProcedure.exception threw for " + procedure, throwable);
        	} finally {
        		barrier.dec();
        	}
        } else {
        	Logger.defaultLogError("Procedure was called many times (this time is exception)");
        }
        
    }
    
    public Result getResult() {
        return result;
    }
    
    public Throwable getException() {
        return exception;
    }
	
}
