package org.simantics.db.impl.internal;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class ResourceData implements RandomAccessBinary {
	private boolean changed = false;
    public final BinaryFile binaryFile;
    public final boolean oldExternalValue; 
    public ResourceData(BinaryFile binaryFile, boolean oldExternalValue) {
        this.binaryFile = binaryFile;
        this.oldExternalValue = oldExternalValue;
    }
    public boolean isChanged() {
    	return changed;
    }
	@Override
	public void writeFully(ByteBuffer src) throws IOException {
		binaryFile.writeFully(src);
		changed = true;
	}
	@Override
	public void writeFully(ByteBuffer src, int length) throws IOException {
		binaryFile.writeFully(src, length);
		changed = true;
	}
	@Override
	public void write(int b) throws IOException {
		binaryFile.write(b);
		changed = true;
	}
	@Override
	public void write(byte[] b) throws IOException {
		binaryFile.write(b);
		changed = true;
	}
	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		binaryFile.write(b, off, len);
		changed = true;
	}
	@Override
	public void writeBoolean(boolean v) throws IOException {
		binaryFile.writeBoolean(v);
		changed = true;
	}
	@Override
	public void writeByte(int v) throws IOException {
		binaryFile.writeByte(v);
		changed = true;
	}
	@Override
	public void writeShort(int v) throws IOException {
		binaryFile.writeShort(v);
		changed = true;
	}
	@Override
	public void writeChar(int v) throws IOException {
		binaryFile.writeChar(v);
		changed = true;
	}
	@Override
	public void writeInt(int v) throws IOException {
		binaryFile.writeInt(v);
		changed = true;
	}
	@Override
	public void writeLong(long v) throws IOException {
		binaryFile.writeLong(v);
		changed = true;
	}
	@Override
	public void writeFloat(float v) throws IOException {
		binaryFile.writeFloat(v);
		changed = true;
	}
	@Override
	public void writeDouble(double v) throws IOException {
		binaryFile.writeDouble(v);
		changed = true;
	}
	@Override
	public void writeBytes(String s) throws IOException {
		binaryFile.writeBytes(s);
		changed = true;
	}
	@Override
	public void writeChars(String s) throws IOException {
		binaryFile.writeChars(s);
		changed = true;
	}
	@Override
	public void writeUTF(String s) throws IOException {
		binaryFile.writeUTF(s);
		changed = true;
	}
	@Override
	public long skipBytes(long bytes) throws IOException {
		return binaryFile.skipBytes(bytes);
	}
	@Override
	public void readFully(ByteBuffer buf) throws IOException {
		binaryFile.readFully(buf);
	}
	@Override
	public void readFully(ByteBuffer buf, int length) throws IOException {
		binaryFile.readFully(buf, length);
	}
	@Override
	public void readFully(byte[] b) throws IOException {
		binaryFile.readFully(b);
	}
	@Override
	public void readFully(byte[] b, int off, int len) throws IOException {
		binaryFile.readFully(b, off, len);
	}
	@Override
	public int skipBytes(int n) throws IOException {
		return binaryFile.skipBytes(n);
	}
	@Override
	public boolean readBoolean() throws IOException {
		return binaryFile.readBoolean();
	}
	@Override
	public byte readByte() throws IOException {
		return binaryFile.readByte();
	}
	@Override
	public int readUnsignedByte() throws IOException {
		return binaryFile.readUnsignedByte();
	}
	@Override
	public short readShort() throws IOException {
		return binaryFile.readShort();
	}
	@Override
	public int readUnsignedShort() throws IOException {
		return binaryFile.readUnsignedShort();
	}
	@Override
	public char readChar() throws IOException {
		return binaryFile.readChar();
	}
	@Override
	public int readInt() throws IOException {
		return binaryFile.readInt();
	}
	@Override
	public long readLong() throws IOException {
		return binaryFile.readLong();
	}
	@Override
	public float readFloat() throws IOException {
		return binaryFile.readFloat();
	}
	@Override
	public double readDouble() throws IOException {
		return binaryFile.readDouble();
	}
	@Override
	public String readLine() throws IOException {
		return binaryFile.readLine();
	}
	@Override
	public String readUTF() throws IOException {
		return binaryFile.readUTF();
	}
	@Override
	public void flush() throws IOException {
		binaryFile.flush();
	}
	@Override
	public void reset() throws IOException {
		binaryFile.reset();
		changed = true;
	}
	@Override
	public void removeBytes(long bytes, ByteSide side) throws IOException {
		binaryFile.removeBytes(bytes, side);
		changed = true;
	}
	@Override
	public void insertBytes(long bytes, ByteSide side) throws IOException {
		binaryFile.insertBytes(bytes, side);
		changed = true;
	}
	@Override
	public void setLength(long newLength) throws IOException {
		binaryFile.setLength(newLength);
		changed = true;
	}
	@Override
	public long length() throws IOException {
		return binaryFile.length();
	}
	@Override
	public void close() throws IOException {
		binaryFile.close();
	}
	@Override
	public boolean isOpen() {
		return binaryFile.isOpen();
	}
	@Override
	public void position(long newPosition) throws IOException {
		binaryFile.position(newPosition);
	}
	@Override
	public long position() throws IOException {
		return binaryFile.position();
	}
}
