package org.simantics.db.impl.graph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.IdentityPair;

import gnu.trove.map.hash.TObjectIntHashMap;

/**
 * Originally within DelayedWriteGraph, put in separate file in 1.30.0.
 * 
 * @author Antti Villberg
 */
class PassthroughSerializerBinding extends Binding {

	static final Serializer serializer = new Serializer() {

		public byte[] serialize(Object obj) throws SerializationException {
			return (byte[])obj;
		}

		@Override
		public void serialize(DataOutput out,
				TObjectIntHashMap<Object> identities, Object obj)
				throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public void serialize(DataOutput out, Object obj)
				throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public Object deserialize(DataInput in, List<Object> identities)
				throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public Object deserialize(DataInput in) throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public void deserializeTo(DataInput in, List<Object> identities,
				Object obj) throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public void deserializeTo(DataInput in, Object obj)
				throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public void skip(DataInput in, List<Object> identities)
				throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public void skip(DataInput in) throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public Integer getConstantSize() {
			throw new Error("Not supported.");
		}

		@Override
		public int getSize(Object obj, TObjectIntHashMap<Object> identities)
				throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public int getSize(Object obj) throws IOException {
			throw new Error("Not supported.");
		}

		@Override
		public int getMinSize() {
			throw new Error("Not supported.");
		}

	};

	@Override
	public Serializer serializer() {
		return serializer;
	}

	@Override
	public void accept(Visitor1 v, Object obj) {
		throw new Error("Not supported.");
	}

	@Override
	public <T> T accept(Visitor<T> v) {
		throw new Error("Not supported.");
	}

	@Override
	public boolean isInstance(Object obj) {
		throw new Error("Not supported.");
	}

	@Override
	public void assertInstaceIsValid(Object obj, Set<Object> validInstances)
			throws org.simantics.databoard.binding.error.BindingException {
		throw new Error("Not supported.");
	}

	@Override
	public int deepHashValue(Object value,
			IdentityHashMap<Object, Object> hashedObjects)
			throws org.simantics.databoard.binding.error.BindingException {
		throw new Error("Not supported.");
	}

	@Override
	public int deepCompare(Object o1, Object o2,
			Set<IdentityPair<Object, Object>> compareHistory)
			throws org.simantics.databoard.binding.error.BindingException {
		throw new Error("Not supported.");
	}

	@Override
	public void readFrom(Binding srcBinding, Object src, Object dst)
			throws org.simantics.databoard.binding.error.BindingException {
		throw new Error("Not supported.");
	}

	@Override
	public Object readFromTry(Binding srcBinding, Object src, Object dst)
			throws org.simantics.databoard.binding.error.BindingException {
		throw new Error("Not supported.");
	}

	@Override
	protected void toString(Object value, BindingPrintContext ctx) throws org.simantics.databoard.binding.error.BindingException {
		throw new Error("Not supported.");
	}

	@Override
	public int getComponentCount() {
		throw new Error("Not supported.");
	}

	@Override
	public Binding getComponentBinding(int index) {
		throw new Error("Not supported.");
	}

	@Override
	public Binding getComponentBinding(ChildReference path) {
		throw new Error("Not supported.");
	}

}