package org.simantics.db.impl;

public class TableHeader  {
    public static final int HEADER_SIZE = 4;
    public static final int EXTRA_SIZE = 4;
    private final int CAPACITY_INDEX; // Max size of memory than can be used for entries. (Table size without header.)
    private final int SIZE_INDEX; // Memory used for entries.
    private final int COUNT_INDEX; // Number of elements.
    private final int OFFSET_INDEX; // Table offset in containing vector minus zero shift.
    private final int EXTRA_INDEX; // Extra header fields for clients.
    private int[] header;
   TableHeader(int[] header, int headerBase) {
       this.CAPACITY_INDEX = headerBase++;
       this.SIZE_INDEX = headerBase++;
       this.COUNT_INDEX = headerBase++;
       this.OFFSET_INDEX = headerBase++;
       this.EXTRA_INDEX = headerBase++;
       this.header = header;
       getOffset();
       getSize();
       getCapacity();
   }
   final int getCapacity() {
       int ret = header[CAPACITY_INDEX];
       if(ret < 0) throw new IllegalStateException();
       return ret;
   }
   final void setCapacity(int a) {
       header[CAPACITY_INDEX] = a;
   }
   final int getSize() {
       int ret = header[SIZE_INDEX];
       if(ret < 0) throw new IllegalStateException();
       if(ret > getCapacity()) throw new IllegalStateException();
       return ret;
   }
   final void setSize(int a) {
       header[SIZE_INDEX] = a;
   }
   public final int getCount() {
       return header[COUNT_INDEX];
   }
   final void setCount(int a) {
       header[COUNT_INDEX] = a;
   }
   public final int getOffset() {
       int ret = header[OFFSET_INDEX];
       if(ret < -1) throw new IllegalStateException();
       return ret; 
   }
   final void setOffset(int a) {
       header[OFFSET_INDEX] = a;
   }
   final int getExtra(int index) {
       if (index < 0 || index >= EXTRA_SIZE)
           throw new IllegalArgumentException();
       return header[EXTRA_INDEX + index];
   }
   final void setExtra(int index, int a) {
       if (index < 0 || index >= EXTRA_SIZE)
           throw new IllegalArgumentException();
       header[EXTRA_INDEX + index] = a;
   }
}