package org.simantics.db.impl;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class PerformanceTests {

	
	public static void collectionTest1() {

		final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) queue.add(this);
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			start = System.nanoTime();
			ArrayList<Object> sink = new ArrayList<Object>();
			queue.drainTo(sink);
			done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}
	
	public static void collectionTest2() {

		final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue<Object>();
		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) queue.add(this);
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			start = System.nanoTime();
			ArrayList<Object> sink = new ArrayList<Object>();
			for(Object o : queue) sink.add(o);
			done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}

	public static void collectionTest3() {

		final ArrayList<Object> queue = new ArrayList<Object>();
		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) {
					synchronized(queue) {
						queue.add(this);
					}
				}
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			start = System.nanoTime();
			ArrayList<Object> sink = new ArrayList<Object>();
			sink.addAll(queue);
			done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}

	public static void collectionTest4() {

		final ArrayList<Object> queue = new ArrayList<Object>();
		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		final ReentrantLock lock = new ReentrantLock();
		final ReentrantLock lock2 = new ReentrantLock();
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) {
					lock.lock();
					queue.add(this);
					lock.unlock();
					lock2.tryLock();
				}
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			start = System.nanoTime();
			ArrayList<Object> sink = new ArrayList<Object>();
			sink.addAll(queue);
			done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}

	public static void counterTest1() {

		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		final AtomicInteger integer = new AtomicInteger();
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) {
					integer.incrementAndGet();
				}
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}

	static int counter = 0;
	
	public static void counterTest2() {

		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		final ReentrantLock lock = new ReentrantLock();
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) {
					lock.lock();
					counter++;
					lock.unlock();
				}
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}

	public static void counterTest3() {

		final CountDownLatch latch1 = new CountDownLatch(9);
		final CountDownLatch latch2 = new CountDownLatch(9);
		//final ReentrantLock lock = new ReentrantLock();
		
		class T extends Thread {

			@Override
			public void run() {
				try {
					latch1.countDown();
					latch1.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				for(int i=0;i<500000;i++) {
					//lock.lock();
					counter++;
					//lock.unlock();
				}
				try {
					latch2.countDown();
					latch2.await();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
		}
		

		for(int i=0;i<8;i++) new T().start();
		
		try {
			latch1.countDown();
			latch1.await();
			long start = System.nanoTime();
			latch2.countDown();
			latch2.await();
			long done = System.nanoTime() - start;
			System.out.println("took " + 1e-9*done);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}
	
	public static void main(String[] args) {
//		collectionTest1();
//		collectionTest2();
//		collectionTest3();
//		collectionTest4();
		counterTest3();
	}
	
}
