/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.impl;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusterUID;

public interface IClusterTable {

	<T extends ClusterI> T getClusterByClusterUIDOrMakeProxy(ClusterUID clusterUID);
	<T extends ClusterI> T getClusterProxyByResourceKey(int resourceKey);
	ClusterUID getClusterUIDByResourceKey(int resourceKey) throws DatabaseException;
	int getClusterKeyByUID(long id1, long id2) throws DatabaseException;
	void markImmutable(int clusterKey, boolean value);

}
