package org.simantics.db.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.procedure.SyncContextProcedure;

public final class ForPossibleRelatedValueContextProcedure<C, T> implements SyncContextProcedure<C, T> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final ClusterI.CompleteTypeEnum completeType;
	private final SyncContextProcedure<C, T> user;
	
	public ForPossibleRelatedValueContextProcedure(int predicateKey, RelationInfo info, SyncContextProcedure<C, T> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(ReadGraph graph, C context, T result) {
		user.execute(graph, context, result);
	}

	@Override
	public void exception(ReadGraph graph, Throwable throwable) {
		user.exception(graph, throwable);
	}
	
};
