/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Literals;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;

public class DatabaseUtils {

    public static String getReadableName(ReadGraph graph, Resource resource) throws ValidationException, ServiceException {
    	Layer0 b = Layer0.getInstance(graph);
    	
    	String uri = graph.getPossibleURI(resource);
    	if(uri != null) return uri;
    	
        List<String> names = new ArrayList<String>(1);
        for(Resource nameResource : graph.getObjects(resource, b.HasName)) {
            Object value = graph.getPossibleValue(nameResource);
            if(value != null) {
                names.add(Literals.shortString(Literals.literalToString(value)));
            }
        }
        if(!names.isEmpty()) {
            if(names.size() == 1)
                return names.get(0);
            else {
                StringBuilder bb = new StringBuilder();
                bb.append('[');
                for(int i=0;i<names.size();++i) {
                    if(i>0)
                        bb.append(", ");
                    bb.append(names.get(i));
                }
                bb.append(']');
                return bb.toString();
            }
        }
        StringBuilder bb = new StringBuilder();
        Object val = graph.getPossibleValue(resource);
        if(val != null) {
            if(val instanceof double[])
                bb.append(Literals.shortString(Arrays.toString((double[])val)));
            else if(val instanceof float[])
                bb.append(Literals.shortString(Arrays.toString((float[])val)));
            else if(val instanceof int[])
                bb.append(Literals.shortString(Arrays.toString((int[])val)));
            else if(val instanceof boolean[])
                bb.append(Literals.shortString(Arrays.toString((boolean[])val)));
            else if(val instanceof long[])
                bb.append(Literals.shortString(Arrays.toString((long[])val)));
            else if(val instanceof byte[])
                bb.append(Literals.shortString(Arrays.toString((byte[])val)));
            else if(val instanceof String[])
                bb.append(Literals.shortString(Arrays.toString((String[])val)));
            else 
                bb.append(Literals.shortString(val));
        }
        else
            bb.append(resource.getResourceId());
        boolean ok = false;
        for(Resource r : graph.getObjects(resource, b.InstanceOf)) {
            bb.append(" : (" + getReadableName(graph, r) + ")");
            ok = true;
        }
        if(!ok) {
            for(Resource r : graph.getObjects(resource, b.Inherits)) {
                bb.append(" <T (" + getReadableName(graph, r) + ")");
                ok = true;
            }   
            if(!ok) {
                for(Resource r : graph.getObjects(resource, b.SubrelationOf)) {
                    bb.append(" <R (" + getReadableName(graph, r) + ")");
                    ok = true;
                }   
            }
        }
        return bb.toString();
    }
    
}
