package org.simantics.db.impl;

import java.util.UUID;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.ClusteringSupport.Id;

abstract public class ClusterBase implements ClusterI, TableSizeListener {
    
    protected static boolean DEBUG = false;
    protected static boolean VERBOSE = false;
    public static class IdImpl implements ClusteringSupport.Id {
        private UUID id;
        public IdImpl(UUID id) {
            this.id = id;
        }
        @Override
        public String toString() {
            long[] longs = toLong();
            return String.format("%x.%x", longs[0], longs[1]);
        }
        @Override
        public boolean equals(Object o) {
            if (null == o)
                return false;
            else if (this == o)
                return true;
            else if (o instanceof IdImpl)
                return this.id.equals(((IdImpl)o).id);
            else if (o instanceof Id) {
                long[] self = toLong();
                long[] other = ((Id)o).toLong();
                if (self[0] != other[0])
                    return false;
                return self[1] == other[1];
            } else
                return false;
        }
        public long[] toLong() {
            long[] longs = new long[2];
            longs[0] = id.getMostSignificantBits();
            longs[1] = id.getLeastSignificantBits();
            return longs;
        }
    }
    public final ClusterUID clusterUID; // unique identifier for this cluster with all servers, persistent
    public final long clusterId; // unique identifier for this cluster with this server, persistent
    public final int clusterKey; // unique identifier for this cluster with this process, transient
//    private Id modifiedId;
    protected long importance;

    protected ClusterBase() {
        this.clusterUID = null;
        this.clusterId = 0;
        this.clusterKey = 0;
    }
    
    public ClusterBase(ClusterSupport support, ClusterUID clusterUID, int clusterKey) {
        this.clusterUID = clusterUID;
        this.clusterId = support.getClusterIdOrCreate(clusterUID);
        this.clusterKey = 0 != clusterKey ? clusterKey : support.createClusterKeyByClusterUID(this.clusterUID, this.clusterId);
//        this.modifiedId = new IdImpl(UUID.randomUUID()); // kraa666
        if (DEBUG) {
            System.out.println("DEBUG: Created cluster " + clusterUID + " id=" + clusterId + " key=" + clusterKey);
            if (VERBOSE)
                new Exception().printStackTrace();
        }
    }

    final public int getClusterKey() {
        return clusterKey;
    }

    final public long getClusterId() {
        return clusterId;
    }

    @Override
    final public long getImportance() {
        return importance;
    }

    @Override
    final public void setImportance(long importance) {
        this.importance = importance;
    }

    @Override
    public ClusterUID getClusterUID() {
        return clusterUID;
    }

//    @Override
//    public Id getModifiedId() {
//        return modifiedId;
//    }
//
//    public void setModifiedId(Id modifiedId) {
//        this.modifiedId = modifiedId;
//    }

    public abstract ClusterBase toBig(ClusterSupport support) throws DatabaseException;
    
    public abstract void checkDirectReference(int dr) throws DatabaseException;

    public abstract void checkForeingIndex(int fi) throws DatabaseException;

    public abstract void checkObjectSetReference(int or) throws DatabaseException;

    public abstract void checkValueInit() throws DatabaseException;

    public abstract void checkCompleteSetReference(int cr) throws DatabaseException;

    public abstract void checkPredicateIndex(int pi) throws DatabaseException;

    public abstract void checkValue(int capacity, int index) throws DatabaseException;

    public abstract void checkValueFini() throws DatabaseException;
    
    public abstract Table<?> getPredicateTable();

    public abstract Table<?> getForeignTable();
    
    public abstract Table<?> getCompleteTable();

    public abstract Table<?> getValueTable();

    public abstract Table<?> getObjectTable();

    public abstract int execute(int p1) throws DatabaseException;

    public abstract int makeResourceKey(int pRef) throws DatabaseException;

    public abstract IClusterTable getClusterTable();

}
