/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class ResourceToURI
extends ResourceRead<String>
implements PersistentRead<String> {
    private static final QueryFactoryKey queryFactoryKey = new QueryFactoryKey("org.simantics.db.common", ResourceToURI.class.getName());

    public ResourceToURI(Resource resource) {
        super(resource);
    }

    public String perform(ReadGraph graph) throws DatabaseException {
        if (this.resource.equals(graph.getRootLibrary())) {
            return "http:/";
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(this.resource, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            throw new AssumptionException("resource " + String.valueOf(this.resource) + " does not have a name");
        }
        String escapedName = URIStringUtils.escape((String)name);
        Resource parent = graph.getPossibleObject(this.resource, L0.PartOf);
        if (parent == null) {
            throw new AssumptionException("resource " + String.valueOf(this.resource) + " does not have a parent");
        }
        String parentURI = (String)graph.syncRequest((Read)new ResourceToURI(parent));
        if (parentURI == null) {
            throw new AssumptionException("parent resource " + String.valueOf(parent) + " has no URI");
        }
        return parentURI + "/" + escapedName;
    }

    public QueryFactoryKey classId() {
        return queryFactoryKey;
    }

    public void serializeValue(QuerySerializer serializer, String value) {
        serializer.addString(value);
    }
}

