/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.recursive;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public abstract class CachedRecursiveSearch<T> {
    private final THashMap<Resource, T> resultMap = new THashMap();
    private static final int NO_VALUE = -1;
    private final TObjectIntHashMap<Resource> indexMap = new TObjectIntHashMap(10, 0.5f, -1);
    private int curIndex;
    private final ArrayList<Resource> stack = new ArrayList();
    private T previousResult;

    protected abstract T getSourceValue(Resource var1) throws DatabaseException;

    protected abstract Collection<Resource> children(Resource var1) throws DatabaseException;

    protected abstract T combineNotNull(T var1, T var2) throws DatabaseException;

    protected T combine(T a, T b) throws DatabaseException {
        if (a == null) {
            return b;
        }
        if (b == null || a == b) {
            return a;
        }
        return this.combineNotNull(a, b);
    }

    public T get(Resource resource) throws DatabaseException {
        if (this.resultMap.contains((Object)resource)) {
            return (T)this.resultMap.get((Object)resource);
        }
        this.curIndex = 0;
        this.calc(resource);
        return this.previousResult;
    }

    private int calc(Resource resource) throws DatabaseException {
        Object result = this.getSourceValue(resource);
        if (result != null) {
            this.resultMap.put((Object)resource, result);
            this.previousResult = result;
            return -1;
        }
        int index = this.curIndex++;
        this.indexMap.put((Object)resource, index);
        this.stack.add(resource);
        int lowindex = index;
        for (Resource child : this.children(resource)) {
            if (this.resultMap.contains((Object)child)) {
                result = this.combine(result, this.resultMap.get((Object)child));
                continue;
            }
            int childIndex = this.indexMap.get((Object)child);
            if (childIndex == -1) {
                childIndex = this.calc(child);
                result = this.combine(result, this.previousResult);
                if (childIndex == -1) continue;
            }
            lowindex = Math.min(lowindex, childIndex);
        }
        if (lowindex == index) {
            Resource r;
            do {
                r = this.stack.remove(this.stack.size() - 1);
                this.indexMap.remove((Object)r);
                this.resultMap.put((Object)r, result);
            } while (r != resource);
            this.previousResult = result;
            return -1;
        }
        this.previousResult = result;
        return lowindex;
    }
}

