/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.procedure.adapter.SyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncProcedure;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.MultiListener;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncMultiListener;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.DelayedWriteResult;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteOnlyResult;
import org.simantics.db.request.WriteResult;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingGraphRequestProcessor
implements AsyncRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergingGraphRequestProcessor.class);
    long transactionKeepalivePeriod;
    Object barrier = new Object();
    Set<Pair<Object, Object>> requestSet = new HashSet<Pair<Object, Object>>();
    LinkedList<Pair<Object, Object>> requestQueue = new LinkedList();
    boolean hasAlreadyRequest = false;
    Set<Object> syncRequests = new HashSet<Object>();
    private String name;
    private AsyncRequestProcessor processor;

    public MergingGraphRequestProcessor(String name, AsyncRequestProcessor processor, long transactionKeepalivePeriod) {
        this.name = name;
        this.processor = processor;
        this.transactionKeepalivePeriod = transactionKeepalivePeriod;
    }

    public MergingGraphRequestProcessor(AsyncRequestProcessor processor, long transactionKeepalivePeriod) {
        this.name = "MergingGraphRequestProcessor" + UUID.randomUUID().toString();
        this.processor = processor;
        this.transactionKeepalivePeriod = transactionKeepalivePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newTransaction() {
        boolean write = false;
        MergingGraphRequestProcessor mergingGraphRequestProcessor = this;
        synchronized (mergingGraphRequestProcessor) {
            assert (!this.requestQueue.isEmpty());
            Object nextRequest = this.requestQueue.peekFirst().first;
            write = nextRequest instanceof Write || nextRequest instanceof DelayedWrite;
        }
        if (write) {
            this.processor.asyncRequest((Write)new RunnerWriteGraphRequest(), null);
        } else {
            this.processor.asyncRequest((Read)new MergedRead());
        }
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, AsyncMultiProcedure<T> procedure) {
        Pair pair = Pair.make(request, procedure);
        if (this.requestSet.contains(pair)) {
            return;
        }
        this.requestQueue.add((Pair<Object, Object>)pair);
        this.requestSet.add((Pair<Object, Object>)pair);
        if (!this.hasAlreadyRequest) {
            this.newTransaction();
            this.hasAlreadyRequest = true;
        } else {
            this.notify();
        }
    }

    public synchronized <T> void asyncRequest(AsyncRead<T> request, AsyncProcedure<T> procedure) {
        Pair pair = Pair.make(request, procedure);
        if (this.requestSet.contains(pair)) {
            return;
        }
        this.requestQueue.add((Pair<Object, Object>)pair);
        this.requestSet.add((Pair<Object, Object>)pair);
        if (!this.hasAlreadyRequest) {
            this.newTransaction();
            this.hasAlreadyRequest = true;
        } else {
            this.notify();
        }
    }

    public synchronized void asyncRequest(Write request, Consumer<DatabaseException> callback) {
        Pair pair = Pair.make((Object)request, callback);
        if (this.requestSet.contains(pair)) {
            return;
        }
        this.requestQueue.add((Pair<Object, Object>)pair);
        this.requestSet.add((Pair<Object, Object>)pair);
        if (!this.hasAlreadyRequest) {
            this.newTransaction();
            this.hasAlreadyRequest = true;
        } else {
            this.notify();
        }
    }

    public synchronized void asyncRequest(DelayedWrite request, Consumer<DatabaseException> callback) {
        Pair pair = Pair.make((Object)request, callback);
        if (this.requestSet.contains(pair)) {
            return;
        }
        this.requestQueue.add((Pair<Object, Object>)pair);
        this.requestSet.add((Pair<Object, Object>)pair);
        if (!this.hasAlreadyRequest) {
            this.newTransaction();
            this.hasAlreadyRequest = true;
        } else {
            this.notify();
        }
    }

    public synchronized void asyncRequest(WriteOnly request, Consumer<DatabaseException> callback) {
        Pair pair = Pair.make((Object)request, callback);
        if (this.requestSet.contains(pair)) {
            return;
        }
        this.requestQueue.add((Pair<Object, Object>)pair);
        this.requestSet.add((Pair<Object, Object>)pair);
        if (!this.hasAlreadyRequest) {
            this.newTransaction();
            this.hasAlreadyRequest = true;
        } else {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, AsyncMultiProcedure<T> procedure) {
        DataContainer throwable = new DataContainer(null);
        AsyncMultiRead<T> asyncMultiRead = request;
        synchronized (asyncMultiRead) {
            this.syncRequests.add(request);
            this.asyncRequest(request, procedure);
            if (this.syncRequests.contains(request)) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    throw new Error(e);
                }
            }
        }
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            LOGGER.error("syncRequest(AsyncMultiRead, AsyncMultiProcedure) failed", t);
            throw new RuntimeException(t.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T syncRequest(AsyncRead<T> request, final AsyncProcedure<T> procedure) {
        final DataContainer result = new DataContainer(null);
        final DataContainer throwable = new DataContainer(null);
        AsyncRead<T> asyncRead = request;
        synchronized (asyncRead) {
            this.syncRequests.add(request);
            this.asyncRequest(request, new AsyncProcedure<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(AsyncReadGraph graph, T t) {
                    DataContainer dataContainer = result;
                    synchronized (dataContainer) {
                        result.set(t);
                    }
                    procedure.execute(graph, t);
                }

                public void exception(AsyncReadGraph graph, Throwable t) {
                    throwable.set((Object)t);
                }

                public String toString() {
                    return procedure.toString();
                }
            });
            if (this.syncRequests.contains(request)) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    throw new Error(e);
                }
            }
        }
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            LOGGER.error("syncRequest(AsyncRead, AsyncProcedure) failed", t);
            throw new RuntimeException(t.getMessage());
        }
        return (T)result.get();
    }

    public void syncRequest(Write request) {
        SyncWriteRequestAdapter adapter = new SyncWriteRequestAdapter(request);
        this.asyncRequest(adapter, null);
        adapter.acquire();
        adapter.throwOrWrapException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRequest(WriteOnly request) {
        SyncWriteRequestAdapter adapter;
        SyncWriteRequestAdapter syncWriteRequestAdapter = adapter = new SyncWriteRequestAdapter(request);
        synchronized (syncWriteRequestAdapter) {
            this.asyncRequest(adapter, null);
            try {
                adapter.wait();
            }
            catch (InterruptedException e) {
                throw new Error(e);
            }
        }
        adapter.throwOrWrapException();
    }

    public Session getSession() {
        return this.processor.getSession();
    }

    public String toString() {
        return "MergingGraphRequestProcessor[" + this.name + "]@" + System.identityHashCode(this) + " (based on " + String.valueOf(this.processor) + ")";
    }

    public <T> void asyncRequest(AsyncRead<T> request) {
        this.asyncRequest(request, new ProcedureAdapter<T>(){

            @Override
            public void exception(Throwable t) {
                LOGGER.error("asyncRequest(AsyncRead) failed", t);
            }
        });
    }

    public <T> void asyncRequest(AsyncRead<T> request, Procedure<T> procedure) {
        this.asyncRequest(request, new NoneToAsyncProcedure<T>(procedure));
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, MultiProcedure<T> procedure) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(AsyncRead<T> request) {
        final DataContainer throwable = new DataContainer(null);
        final DataContainer result = new DataContainer();
        this.syncRequest(request, new AsyncProcedure<T>(){

            public void execute(AsyncReadGraph graph, T t) {
                result.set(t);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                throwable.set((Object)t);
            }
        });
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            LOGGER.error("syncRequest(AsyncRead) failed", t);
            throw new RuntimeException(t.getMessage());
        }
        return (T)result.get();
    }

    public <T> T syncRequest(AsyncRead<T> request, Procedure<T> procedure) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request) {
        final DataContainer throwable = new DataContainer(null);
        final ArrayList result = new ArrayList();
        this.syncRequest(request, new AsyncMultiProcedureAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(AsyncReadGraph graph, T t) {
                ArrayList arrayList = result;
                synchronized (arrayList) {
                    result.add(t);
                }
            }

            @Override
            public void exception(AsyncReadGraph graph, Throwable t) {
                throwable.set((Object)t);
            }
        });
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            LOGGER.error("syncRequest(AsyncMultiRead) failed", t);
            throw new RuntimeException(t.getMessage());
        }
        return result;
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, MultiProcedure<T> procedure) {
        throw new Error("Not implemented.");
    }

    public <T> T syncRequest(Read<T> request) {
        final DataContainer throwable = new DataContainer(null);
        final DataContainer result = new DataContainer();
        this.syncRequest(request, new Procedure<T>(){

            public void execute(T t) {
                result.set(t);
            }

            public void exception(Throwable t) {
                throwable.set((Object)t);
            }
        });
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            throw new Error(t.getMessage());
        }
        return (T)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T syncRequest(Read<T> request, final AsyncProcedure<T> procedure) {
        final DataContainer result = new DataContainer(null);
        final DataContainer throwable = new DataContainer(null);
        Read<T> read = request;
        synchronized (read) {
            this.syncRequests.add(request);
            this.asyncRequest(request, new AsyncProcedure<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(AsyncReadGraph graph, T t) {
                    DataContainer dataContainer = result;
                    synchronized (dataContainer) {
                        result.set(t);
                    }
                    procedure.execute(graph, t);
                }

                public void exception(AsyncReadGraph graph, Throwable t) {
                    throwable.set((Object)t);
                }

                public String toString() {
                    return procedure.toString();
                }
            });
            if (this.syncRequests.contains(request)) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    throw new Error(e);
                }
            }
        }
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            throw new RuntimeException("Unexpected exception in MergingGraphRequestProcessor.syncRequest(Read, AsyncProcedure)", t);
        }
        return (T)result.get();
    }

    public <T> void asyncRequest(Read<T> request) {
        this.asyncRequest(request, new ProcedureAdapter<T>(){

            @Override
            public void exception(Throwable t) {
                LOGGER.error("asyncRequest(Read) failed", t);
            }
        });
    }

    public synchronized <T> void asyncRequest(Read<T> request, AsyncProcedure<T> procedure) {
        Pair pair = Pair.make(request, procedure);
        if (this.requestSet.contains(pair)) {
            return;
        }
        this.requestQueue.add((Pair<Object, Object>)pair);
        this.requestSet.add((Pair<Object, Object>)pair);
        if (!this.hasAlreadyRequest) {
            this.newTransaction();
            this.hasAlreadyRequest = true;
        } else {
            this.notify();
        }
    }

    public <T> T syncRequest(Read<T> request, Procedure<T> procedure) {
        return this.syncRequest(request, new NoneToAsyncProcedure<T>(procedure));
    }

    public <T> Collection<T> syncRequest(final MultiRead<T> request) throws DatabaseException {
        assert (request != null);
        final ArrayList result = new ArrayList();
        final DataContainer exception = new DataContainer();
        this.syncRequest(request, new SyncMultiProcedureAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ReadGraph graph, T t) {
                ArrayList arrayList = result;
                synchronized (arrayList) {
                    result.add(t);
                }
            }

            @Override
            public void exception(ReadGraph graph, Throwable t) {
                exception.set((Object)t);
            }

            public String toString() {
                return "syncRequest(MultiRead) -> " + String.valueOf(request);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(Read)", t);
        }
        return result;
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, MultiProcedure<T> procedure) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T> void asyncRequest(Read<T> request, Procedure<T> procedure) {
        this.asyncRequest(request, new NoneToAsyncProcedure<T>(procedure));
    }

    public <T> void asyncRequest(MultiRead<T> request) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T> void asyncRequest(MultiRead<T> request, MultiProcedure<T> procedure) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void asyncRequest(Write r) {
        this.asyncRequest(r, null);
    }

    public void asyncRequest(DelayedWrite r) {
        this.asyncRequest(r, null);
    }

    public void asyncRequest(WriteOnly r) {
        this.asyncRequest(r, null);
    }

    public <T> T getService(Class<T> api) {
        return (T)this.getSession().getService(api);
    }

    public <T> T peekService(Class<T> api) {
        return (T)this.getSession().peekService(api);
    }

    public boolean hasService(Class<?> api) {
        return this.getSession().hasService(api);
    }

    public <T> void registerService(Class<T> api, T service) {
        this.getSession().registerService(api, service);
    }

    public <T> T syncRequest(Read<T> arg0, SyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(Read<T> arg0, Listener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(Read<T> arg0, SyncProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(AsyncRead<T> arg0, AsyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(AsyncRead<T> arg0, SyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(AsyncRead<T> arg0, Listener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(AsyncRead<T> arg0, SyncProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(Read<T> arg0, AsyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(Read<T> arg0, SyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(Read<T> arg0, Listener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(Read<T> arg0, SyncProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncRead<T> arg0, AsyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncRead<T> arg0, SyncListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncRead<T> arg0, Listener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncRead<T> arg0, SyncProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(MultiRead<T> arg0, SyncMultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(MultiRead<T> arg0, MultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(MultiRead<T> arg0, SyncMultiProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> arg0, AsyncMultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> arg0, SyncMultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> arg0, MultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> arg0, SyncMultiProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(MultiRead<T> arg0, SyncMultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(MultiRead<T> arg0, MultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(MultiRead<T> arg0, SyncMultiProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncMultiRead<T> arg0, AsyncMultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncMultiRead<T> arg0, SyncMultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncMultiRead<T> arg0, MultiListener<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(AsyncMultiRead<T> arg0, SyncMultiProcedure<T> arg1) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(ExternalRead<T> request, Procedure<T> procedure) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(ExternalRead<T> request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(ExternalRead<T> request, Listener<T> procedure) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(ExternalRead<T> request, Procedure<T> procedure) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(ExternalRead<T> request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> void asyncRequest(ExternalRead<T> request, Listener<T> procedure) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void syncRequest(DelayedWrite request) throws DatabaseException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public <T> T syncRequest(WriteResult<T> request) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <T> T syncRequest(DelayedWriteResult<T> request) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <T> T syncRequest(WriteOnlyResult<T> r) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <T> void asyncRequest(WriteResult<T> r, Procedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void asyncRequest(DelayedWriteResult<T> r, Procedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void asyncRequest(WriteOnlyResult<T> r, Procedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public Resource getRootLibrary() {
        return this.processor.getRootLibrary();
    }

    public Resource getDefaultMutableClusterSet() {
        return this.processor.getDefaultMutableClusterSet();
    }

    public Resource getDefaultImmutableClusterSet() {
        return this.processor.getDefaultImmutableClusterSet();
    }

    public <T> void async(ReadInterface<T> r, Procedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void async(ReadInterface<T> r, AsyncProcedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void async(ReadInterface<T> r, SyncProcedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void async(ReadInterface<T> r, Listener<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void async(ReadInterface<T> r, AsyncListener<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void async(ReadInterface<T> r, SyncListener<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> T sync(ReadInterface<T> r) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <T> T sync(WriteInterface<T> r) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <T> void async(WriteInterface<T> r, Procedure<T> procedure) {
        throw new UnsupportedOperationException();
    }

    public <T> void async(WriteInterface<T> r) {
        throw new UnsupportedOperationException();
    }

    public Object getModificationCounter() {
        throw new UnsupportedOperationException();
    }

    public <T> T l0() {
        return (T)this.processor.l0();
    }

    protected class MergedRead
    extends ReadRequest {
        Pair<Object, Object> currentRequest;

        protected MergedRead() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(ReadGraph graph) {
            MergingGraphRequestProcessor mergingGraphRequestProcessor;
            while (true) {
                AsyncMultiRead req;
                mergingGraphRequestProcessor = MergingGraphRequestProcessor.this;
                synchronized (mergingGraphRequestProcessor) {
                    Object nextRequest;
                    if (MergingGraphRequestProcessor.this.requestQueue.isEmpty()) {
                        if (MergingGraphRequestProcessor.this.transactionKeepalivePeriod > 0L) {
                            try {
                                MergingGraphRequestProcessor.this.wait(MergingGraphRequestProcessor.this.transactionKeepalivePeriod);
                            }
                            catch (InterruptedException e) {
                                LOGGER.error("MergedRead interrupted", (Throwable)e);
                            }
                            if (MergingGraphRequestProcessor.this.requestQueue.isEmpty()) {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                    if ((nextRequest = MergingGraphRequestProcessor.this.requestQueue.peekFirst().first) instanceof Write || nextRequest instanceof DelayedWrite) {
                        break;
                    }
                    this.currentRequest = MergingGraphRequestProcessor.this.requestQueue.remove(0);
                    MergingGraphRequestProcessor.this.requestSet.remove(this.currentRequest);
                }
                if (MergingGraphRequestProcessor.this.syncRequests.contains(this.currentRequest.first)) {
                    try {
                        if (this.currentRequest.second instanceof AsyncProcedure) {
                            if (this.currentRequest.first instanceof Read) {
                                req = (Read)this.currentRequest.first;
                                graph.syncRequest((Read)req, (AsyncProcedure)this.currentRequest.second);
                            } else {
                                req = (AsyncRead)this.currentRequest.first;
                                graph.syncRequest((AsyncRead)req, (AsyncProcedure)this.currentRequest.second);
                            }
                        } else {
                            req = (AsyncMultiRead)this.currentRequest.first;
                            graph.syncRequest(req, (AsyncMultiProcedure)this.currentRequest.second);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("MergedRead failed", t);
                    }
                    Object t = this.currentRequest.first;
                    synchronized (t) {
                        MergingGraphRequestProcessor.this.syncRequests.remove(this.currentRequest.first);
                        this.currentRequest.first.notify();
                    }
                }
                try {
                    if (this.currentRequest.second instanceof AsyncProcedure) {
                        if (this.currentRequest.first instanceof AsyncRead) {
                            req = (AsyncRead)this.currentRequest.first;
                            graph.syncRequest((AsyncRead)req, (AsyncProcedure)this.currentRequest.second);
                            continue;
                        }
                        req = (Read)this.currentRequest.first;
                        graph.syncRequest((Read)req, (AsyncProcedure)this.currentRequest.second);
                        continue;
                    }
                    req = (AsyncMultiRead)this.currentRequest.first;
                    graph.syncRequest(req, (AsyncMultiProcedure)this.currentRequest.second);
                }
                catch (Throwable t) {
                    LOGGER.error("MergedRead failed", t);
                }
            }
            mergingGraphRequestProcessor = MergingGraphRequestProcessor.this;
            synchronized (mergingGraphRequestProcessor) {
                if (MergingGraphRequestProcessor.this.requestQueue.isEmpty()) {
                    MergingGraphRequestProcessor.this.hasAlreadyRequest = false;
                } else {
                    MergingGraphRequestProcessor.this.newTransaction();
                }
            }
        }

        public String toString() {
            return "MergedRead[" + MergingGraphRequestProcessor.this.requestQueue.size() + " requests]";
        }
    }

    protected class RunnerWriteGraphRequest
    extends WriteRequest {
        Pair<Object, Object> currentRequest;
        HashMap<String, String> metadata = new HashMap();

        protected RunnerWriteGraphRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(WriteGraph graph) throws DatabaseException {
            MergingGraphRequestProcessor mergingGraphRequestProcessor;
            while (true) {
                mergingGraphRequestProcessor = MergingGraphRequestProcessor.this;
                synchronized (mergingGraphRequestProcessor) {
                    Object nextRequest;
                    if (MergingGraphRequestProcessor.this.requestQueue.isEmpty()) {
                        if (MergingGraphRequestProcessor.this.transactionKeepalivePeriod > 0L) {
                            try {
                                MergingGraphRequestProcessor.this.wait(MergingGraphRequestProcessor.this.transactionKeepalivePeriod);
                            }
                            catch (InterruptedException e) {
                                LOGGER.error("RunnerWriteGraphRequest interrupted", (Throwable)e);
                            }
                            if (MergingGraphRequestProcessor.this.requestQueue.isEmpty()) {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                    if ((nextRequest = MergingGraphRequestProcessor.this.requestQueue.peekFirst().first) instanceof AsyncMultiRead || nextRequest instanceof AsyncRead || nextRequest instanceof Read) {
                        break;
                    }
                    this.currentRequest = MergingGraphRequestProcessor.this.requestQueue.remove(0);
                    MergingGraphRequestProcessor.this.requestSet.remove(this.currentRequest);
                }
                Consumer callback = (Consumer)this.currentRequest.second;
                if (this.currentRequest.first.getClass().equals(SyncWriteRequestAdapter.class)) {
                    SyncWriteRequestAdapter adapter;
                    block25: {
                        adapter = (SyncWriteRequestAdapter)this.currentRequest.first;
                        try {
                            graph.syncRequest((Write)adapter);
                            if (callback != null) {
                                callback.accept(null);
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error("RunnerWriteGraphRequest failed", t);
                            if (callback == null) break block25;
                            callback.accept(t);
                        }
                    }
                    adapter.release();
                    continue;
                }
                try {
                    if (this.currentRequest.first instanceof Write) {
                        graph.syncRequest((Write)this.currentRequest.first);
                    } else if (this.currentRequest.first instanceof DelayedWrite) {
                        graph.syncRequest((DelayedWrite)this.currentRequest.first);
                    }
                    if (callback == null) continue;
                    callback.accept(null);
                }
                catch (Throwable t) {
                    LOGGER.error("RunnerWriteGraphRequest failed", t);
                    if (callback == null) continue;
                    callback.accept(t);
                }
            }
            mergingGraphRequestProcessor = MergingGraphRequestProcessor.this;
            synchronized (mergingGraphRequestProcessor) {
                if (MergingGraphRequestProcessor.this.requestQueue.isEmpty()) {
                    MergingGraphRequestProcessor.this.hasAlreadyRequest = false;
                } else {
                    MergingGraphRequestProcessor.this.newTransaction();
                }
            }
        }
    }

    private static class SyncWriteRequestAdapter
    implements Write {
        private Semaphore semaphore = new Semaphore(0);
        private Object request;
        private Throwable exception;

        SyncWriteRequestAdapter(Write r) {
            this.request = r;
        }

        SyncWriteRequestAdapter(WriteOnly r) {
            this.request = r;
        }

        public void perform(WriteGraph g) throws DatabaseException, CancelTransactionException {
            if (this.request instanceof Write) {
                ((Write)this.request).perform(g);
            } else if (this.request instanceof DelayedWrite) {
                ((DelayedWrite)this.request).perform(g);
            } else {
                ((WriteOnly)this.request).perform((WriteOnlyGraph)g);
            }
        }

        public void throwOrWrapException() {
            if (this.exception == null) {
                return;
            }
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            throw new RuntimeException("See cause for the real exception.", this.exception);
        }

        public void acquire() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.error("SyncWriteRequestAdapter interrupted", (Throwable)e);
            }
        }

        public void release() {
            this.semaphore.release();
        }

        public String toString() {
            return "SyncWriteRequestAdapter " + String.valueOf(this.request);
        }
    }
}

