/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.simantics.db.common.utils.Logger;

public final class ByteFileWriter {
    public static int BUFFER = 65536;
    private FileChannel channel;
    private FileOutputStream out;
    byte[] bytes = new byte[BUFFER];
    ByteBuffer bb = ByteBuffer.wrap(this.bytes);
    int byteIndex = 0;

    public ByteFileWriter(File file) throws FileNotFoundException {
        this.out = new FileOutputStream(file);
        this.channel = this.out.getChannel();
    }

    public void write(short s) {
        if (this.byteIndex < BUFFER - 2) {
            this.bytes[this.byteIndex++] = (byte)(s & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(s >>> 8 & 0xFF);
        } else {
            int has = BUFFER - this.byteIndex;
            if (has == 0) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(s & 0xFF);
            if (has == 1) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(s >>> 8 & 0xFF);
            if (has == 2) {
                this.writeReset(BUFFER);
            }
        }
    }

    public void write(int i) {
        if (this.byteIndex < BUFFER - 4) {
            this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
        } else {
            int has = BUFFER - this.byteIndex;
            if (has == 0) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
            if (has == 1) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
            if (has == 2) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
            if (has == 3) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
            if (has == 4) {
                this.writeReset(BUFFER);
            }
        }
    }

    public void write(long l) {
        if (this.byteIndex < BUFFER - 8) {
            this.bytes[this.byteIndex++] = (byte)(l & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 8 & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 16 & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 24 & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 32 & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 40 & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 48 & 0xFFL);
            this.bytes[this.byteIndex++] = (byte)(l >>> 56 & 0xFFL);
        } else {
            int has = BUFFER - this.byteIndex;
            if (has == 0) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l & 0xFFL);
            if (has == 1) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 8 & 0xFFL);
            if (has == 2) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 16 & 0xFFL);
            if (has == 3) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 24 & 0xFFL);
            if (has == 4) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 32 & 0xFFL);
            if (has == 5) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 40 & 0xFFL);
            if (has == 6) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 48 & 0xFFL);
            if (has == 7) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(l >>> 56 & 0xFFL);
            if (has == 8) {
                this.writeReset(BUFFER);
            }
        }
    }

    public void write(byte[] data) {
        int offset = 0;
        int has = BUFFER - this.byteIndex;
        int left = data.length;
        if (has > left) {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, left);
            this.byteIndex += left;
        } else if (has == left) {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, left);
            this.writeReset(BUFFER);
        } else {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, has);
            this.writeReset(BUFFER);
            left -= has;
            offset += has;
            while (left > 0) {
                int length = Math.min(left, BUFFER);
                System.arraycopy(data, offset, this.bytes, 0, length);
                offset += length;
                left -= length;
                if (length < BUFFER) {
                    this.byteIndex = length;
                    continue;
                }
                this.writeReset(BUFFER);
            }
        }
    }

    public void commit() {
        try {
            if (this.byteIndex > 0) {
                this.writeReset(this.byteIndex);
            }
            this.out.close();
        }
        catch (IOException e) {
            Logger.defaultLogError(e);
        }
    }

    private void writeReset(int size) {
        this.byteIndex = 0;
        this.bb.position(0);
        this.bb.limit(size);
        try {
            int got = 0;
            while (got < size) {
                if ((got += this.channel.write(this.bb)) != -1) continue;
                new Exception().printStackTrace();
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

