/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.common.NamedResource;
import org.simantics.utils.strings.AlphanumComparator;

public class VersionInfo {
    public String baseName;
    public String version;
    public Collection<NamedResource> versions;

    public VersionInfo(String baseName, String version, Collection<NamedResource> versions) {
        this.baseName = baseName;
        this.version = version;
        this.versions = versions;
    }

    public boolean containsVersion(String version) {
        for (NamedResource r : this.versions) {
            if (!r.getName().equals(version)) continue;
            return true;
        }
        return false;
    }

    public Collection<NamedResource> getOlderVersions() {
        ArrayList<NamedResource> result = new ArrayList<NamedResource>();
        for (NamedResource r : this.versions) {
            if (AlphanumComparator.COMPARATOR.compare((Object)r.getName(), (Object)this.version) >= 0) continue;
            result.add(r);
        }
        return result;
    }

    public Collection<NamedResource> getNewerVersions() {
        ArrayList<NamedResource> result = new ArrayList<NamedResource>();
        for (NamedResource r : this.versions) {
            if (AlphanumComparator.COMPARATOR.compare((Object)r.getName(), (Object)this.version) <= 0) continue;
            result.add(r);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof VersionInfo)) {
            return false;
        }
        VersionInfo r = (VersionInfo)object;
        return r.baseName.equals(this.baseName) && r.version.equals(this.version) && r.versions.equals(this.versions);
    }

    public int hashCode() {
        return this.baseName.hashCode() + 31 * this.version.hashCode() + 41 * this.versions.hashCode();
    }
}

