/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.Arrays;
import java.util.List;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;

public class TagUtil {
    private final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;

    public static void execute(Session session, String virtualGraphId, String tagURI, boolean tag, Resource ... resources) {
        TagUtil.execute(session, virtualGraphId, tagURI, tag, Arrays.asList(resources));
    }

    public static void execute(Session session, String virtualGraphId, String tagURI, boolean tag, List<Resource> resources) {
        new TagUtil(virtualGraphId, tagURI, tag).execute(session, resources);
    }

    public TagUtil(String virtualGraphId, String tagURI, boolean tag) {
        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
    }

    public void execute(Session session, Resource ... resources) {
        this.execute(session, Arrays.asList(resources));
    }

    public void execute(Session session, final List<Resource> resources) {
        VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.asyncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                TagUtil.this.processSelection(graph, resources);
            }
        }, e -> {
            if (e != null) {
                this.handleError((DatabaseException)((Object)e));
            }
        });
    }

    public void syncExecute(Session session, Resource ... resources) throws DatabaseException {
        this.syncExecute(session, Arrays.asList(resources));
    }

    public void syncExecute(Session session, final List<Resource> resources) throws DatabaseException {
        VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                TagUtil.this.processSelection(graph, resources);
            }
        });
    }

    protected void processSelection(WriteGraph graph, List<Resource> resources) throws DatabaseException {
        if (this.tagURI == null) {
            return;
        }
        final Resource tr = graph.getResource(this.tagURI);
        for (final Resource r : resources) {
            CommentMetadata cm;
            if (this.tag) {
                if (this.virtualGraphId == null) {
                    VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                    VirtualGraph vg = vgs.getGraph((ReadGraph)graph, r);
                    if (vg != null) {
                        graph.sync((WriteInterface)new WriteRequest(vg){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                graph.claim(r, tr, r);
                                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                                graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)("Marking " + NameUtils.getSafeLabel((ReadGraph)graph, r) + " to " + NameUtils.getSafeName((ReadGraph)graph, tr)))));
                            }
                        });
                        continue;
                    }
                    graph.claim(r, tr, r);
                    CommentMetadata cm2 = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                    graph.addMetadata((Metadata)cm2.add(ObjectUtils.toString((Object)("Marking " + NameUtils.getSafeLabel((ReadGraph)graph, r) + " to " + NameUtils.getSafeName((ReadGraph)graph, tr)))));
                    continue;
                }
                graph.claim(r, tr, r);
                cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)("Marking " + NameUtils.getSafeLabel((ReadGraph)graph, r) + " to " + NameUtils.getSafeName((ReadGraph)graph, tr)))));
                continue;
            }
            graph.deny(r, tr, r);
            cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)("Denying " + NameUtils.getSafeLabel((ReadGraph)graph, r) + " to " + NameUtils.getSafeName((ReadGraph)graph, tr)))));
        }
    }

    protected void handleError(DatabaseException e) {
        Logger.defaultLogError(e);
    }
}

