/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class FunctionalStatementMapOfResource
extends ResourceRead<Map<String, Resource>> {
    public FunctionalStatementMapOfResource(Resource resource) {
        super(resource);
    }

    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection predicates = graph.getPredicates(this.resource);
        THashMap result = new THashMap(predicates.size());
        for (Resource predicate : predicates) {
            if (!graph.isInstanceOf(predicate, L0.FunctionalRelation)) continue;
            String name = (String)graph.getPossibleRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
            Resource obj = graph.getSingleObject(this.resource, predicate);
            if (name == null) continue;
            result.put((Object)name, (Object)obj);
        }
        return result;
    }
}

